% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lab.R
\name{lab}
\alias{lab}
\title{Create object lab}
\usage{
lab(
  file,
  id,
  age,
  sex,
  norm,
  no_norm,
  is_post = T,
  cl_sign = NA,
  site = NA,
  name_to_find = "name_is_norm"
)
}
\arguments{
\item{file}{A character scalar. Path to the laboratory's reference in the excel table.}

\item{id}{A column name of the subject id in the dataset, without quotes.}

\item{age}{A column name of the subject age in the dataset, without quotes.}

\item{sex}{A column name of the subject sex in the dataset, without quotes.}

\item{norm}{A normal estimate, for example, "NORMAL".}

\item{no_norm}{An abnormal estimate, for example, "ABNORMAL".}

\item{is_post}{A logical scalar, default is TRUE. True is postfix, otherwise, prefix.}

\item{cl_sign}{A clinical significant estimate, for example, "CLISIG", default: NA.}

\item{site}{A site number, default: NA.}

\item{name_to_find}{A character scalar. For search prefixes or postfixes, default is "name_is_norm".}
}
\value{
The object lab.
}
\description{
Create object lab
}
\examples{
obj_lab <- lab("lab_refer.xlsx", id, age, sex, 1, 2)
obj_lab <- lab("lab_refer.xlsx", id, age, sex, "NORMAL", "NOCLISIG", cl_sign = "CLISIG")
obj_lab <- lab("lab_refer.xlsx", id, age, sex, "norm", "no", FALSE)

}
