% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schema.R
\name{sql_schema_list}
\alias{sql_schema_list}
\title{List schemas on a database}
\usage{
sql_schema_list(dest, include_default = TRUE, ...)
}
\arguments{
\item{dest}{An object of class \code{"src"} or \code{"DBIConnection"}.}

\item{include_default}{Boolean, if \code{TRUE} (default), also the default schema
on the database is included in the result}

\item{...}{Passed on to the individual methods.}
}
\value{
A tibble with the following columns:
\describe{
\item{\code{schema_name}}{the names of the schemas,}
\item{\code{schema_owner}}{the schema owner names.}
}
}
\description{
\code{sql_schema_list()} lists the available schemas on the database.
}
\details{
Methods are not available for all DBMS.

Additional arguments are:
\itemize{
\item \code{dbname}: supported for MSSQL. List schemas on a different database on the connected MSSQL-server;
default: database addressed by \code{dest}.
}
}
\seealso{
Other schema handling functions: 
\code{\link{sql_schema_create}()},
\code{\link{sql_schema_drop}()},
\code{\link{sql_schema_exists}()}
}
\concept{schema handling functions}
