% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcc_new.R
\name{dcc6}
\alias{dcc6}
\title{Data cube creation}
\usage{
dcc6(.data, .variables, .funs_list = list(n = ~n()), .total = "Totale",
  order_type = extract_unique4, .all = TRUE)
}
\arguments{
\item{.data}{data frame to be processed.}

\item{.variables}{variables to split data frame by, as a character vector 
(\code{c("var1", "var2")}).}

\item{.funs_list}{a list of function calls in the form of right-hand formula.}

\item{.total}{character string with the name to give to the subset of data
that includes all the observations of a variable (default: \code{"Totale"}).}

\item{order_type}{a function like \code{\link{extract_unique}} or 
\code{\link{extract_unique2}}.}

\item{.all}{logical, indicating if functions' have to be evaluated on the 
complete dataset.}
}
\description{
Data cube creation
}
\examples{
dcc6(invented_wages,
     .variables = c("gender", "sector"), 
     .funs_list = list(n = ~n()),
     .all = TRUE)
     
dcc6(invented_wages,
     .variables = c("gender", "sector"), 
     .funs_list = list(n = ~n()),
     .all = FALSE)

}
