\name{Version Management}
\docType{methods}
\alias{getVersion}
\alias{getVersion-methods}
\alias{getVersion,Dataclass-method}
\alias{conv2NewVersion-methods}
\alias{conv2NewVersion,Dataclass-method}
\title{ Methods for Version Management in Package `distrSim' }
\description{Version-Management-methods}
\usage{
\S4method{getVersion}{Dataclass}(object)
\S4method{conv2NewVersion}{Dataclass}(object)
}
\arguments{
  \item{object}{object of class  \code{"Dataclass"} (or subclasses)}
}
\section{Far-reaching Change in Design}{
 From version 1.8 of this package on, we have changed the format how data / simulations are stored:
 In order to be able to cope with multivariate distributions, regression distributions and (later)
 time series distributions, we have switched to the common array format: 
 samplesize x obsDim x runs; for saved objects from earlier versions, we provide the functions
 \code{isOldVersion} (from package \pkg{distr}) and \code{conv2NewVersion} to check whether the object was generated by an 
 older version of this package and to convert such an object to the new format, respectively. 
}
\section{Methods}{\describe{
\item{getVersion}{\code{signature(object = "Dataclass")}: returns slot \code{version} of an object
                  of class \code{"Dataclass"}.
 }
\item{conv2NewVersion}{\code{signature(object = "Dataclass")}: 
changes an object with format runs x samplesize (old format) to 
samplesize x obsDim x runs (new format)}
 }
}
\seealso{\code{\link[distr:versionmanagement]{isOldVersion}}, \code{\link[distr:versionmanagement]{conv2NewVersion}}}
\keyword{utilities}
\concept{version management}
