\name{distrSim-package}
\alias{distrSim-package}
\alias{distrSim}
\docType{package}
\title{
distrSim -- S4-classes for Simulations Based on Package distr
}
\description{
\pkg{distrSim} is to provide a conceptual treatment of simulations by means of S4 classes.
The package is based on our package \pkg{distr}, hence uses distribution classes 
as introduced there to describe the distributions under which simulations are performed.
}
\details{
\tabular{ll}{
Package: \tab distrSim \cr
Version: \tab 2.8.0 \cr
Date: \tab 2019-03-11 \cr
Depends: \tab R(>= 2.14.0), methods, graphics, setRNG(>= 2006.2-1), distr(>= 2.5.2) \cr
Suggests: \tab distrEx(>= 2.2)  \cr
Imports: \tab startupmsg, stats, grDevices  \cr
LazyLoad: \tab yes \cr
License: \tab LGPL-3 \cr
URL: \tab http://distr.r-forge.r-project.org/\cr
VCS/SVNRevision: \tab 1314 \cr
}
}
\section{Classes}{
\preformatted{
"SeqDataFrame"
      slots: data(list[of dataframes with common column structure])
"Dataclass"
      slots: [<name>(<class>)] 
      filename(vectororNULL), 
      name(character), 
      Data(ArrayorNULLorVectororDataframeorSeqDataFrames), 
      runs(numeric), 
      samplesize(numeric),
      obsDim(numeric)      
|>"Simulation"
      (additional) slots: [<name>(<class>)] 
      seed(list), distribution(Distribution)
|>"Contsimulation"
      (additional) slots: [<name>(<class>)] 
      seed(list), ind(vectororNULL), rate(numeric),
      distribution.id(Distribution),
      distribution.c(Distribution),
      Data.id(vectororNULL),
      Data.c(vectororNULL)
}}

\section{Methods}{
\preformatted{
savedata                Methods to save the data slot 
                       (for Simulation/Contsimulation)
simulate                Methods to fill the data slot 
                       (for Simulation/Contsimulation)
plot-methods            Methods for Function plot
                       (for Simulation/Contsimulation)
print-, show-methods    Methods for Function print/show 
                       (for Simulation/Contsimulation)
summary-methods         Methods for Function summary 
                       (for Simulation/Contsimulation)
}}
\section{Functions}{
\preformatted{
cload                   loads just the comment slot 
                       (for Simulation/Contsimulation)
}}

\section{Slot accessors / -replacement functions}{
All slots are inspected / modified by corresponding 
accessors / -replacement functions, e.g. \code{rate(X)} for
an object of class \code{"Contsimulation"}.
}

\author{
  Thomas Stabla \email{statho3@web.de},\cr 
  Florian Camphausen \email{fcampi@gmx.de},\cr
  Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de},\cr 
  Matthias Kohl \email{Matthias.Kohl@stamats.de}\cr
  \emph{Maintainer:}  Peter Ruckdeschel \email{peter.ruckdeschel@uni-oldenburg.de}
  }

\section{Start-up-Banner}{
You may suppress the start-up banner/message completely by setting \code{options("StartupBanner"="off")}
somewhere before loading this package by \code{library} or \code{require} in your R-code / R-session.

If option \code{"StartupBanner"} is not defined (default) or setting    
\code{options("StartupBanner"=NULL)} or  \code{options("StartupBanner"="complete")} 
the complete start-up banner is displayed.

For any other value of option \code{"StartupBanner"} (i.e., not in \code{c(NULL,"off","complete")})
only the version information is displayed.

The same can be achieved by wrapping the \code{library} or \code{require}  call into
either \code{\link[startupmsg:StartupUtilities]{suppressStartupMessages}()} or 
\code{\link[startupmsg:StartupUtilities]{onlytypeStartupMessages}(.,atypes="version")}. 
}

\section{Far-reaching Change in Design}{
 From version 1.8 of this package on, we have changed the format how data / simulations are stored:
 In order to be able to cope with multivariate distributions, regression distributions and (later)
 time series distributions, we have switched to the common array format: 
  samplesize x obsDim x runs; you may check the version under which an object was generated by
 \code{\link{getVersion}}; for saved objects from earlier versions, we provide the functions
 \code{\link[distr:versionmanagement]{isOldVersion}}, and  \code{\link{conv2NewVersion-methods}} 
 to check whether the object was generated by an older version of this package and to convert
 such an object to the new format, respectively. 
}

\note{Global options controlling the plots and summaries of Dataclass and Simulation/Contsimulation 
objects may be inspected / set by \code{\link{distrSimoptions}()} 
and \code{\link{getdistrSimOption}()}.
}


\references{
P. Ruckdeschel, M. Kohl, T. Stabla, F. Camphausen (2006):
S4 Classes for Distributions, \emph{R News}, \emph{6}(2), 2-6. 
\url{https://CRAN.R-project.org/doc/Rnews/Rnews_2006-2.pdf}

A vignette for packages \pkg{distr}, \pkg{distrSim}, \pkg{distrTEst}, and \pkg{distrEx} 
is included into the mere documentation package \pkg{distrDoc} and may be called by 
\code{require("distrDoc");vignette("distr")}.

%A more detailed manual for \pkg{distr}, \pkg{distrSim}, \pkg{distrTEst}, and \pkg{distrEx} may be downloaded from  
%\url{http://www.uni-bayreuth.de/departments/math/org/mathe7/DISTR/distr.pdf}.

A homepage to this package is available under\cr
\url{http://distr.r-forge.r-project.org/}
}
\section{Start-up-Banner}{
You may suppress the start-up banner/message completely by setting \code{options("StartupBanner"="off")}
somewhere before loading this package by \code{library} or \code{require} in your R-code / R-session.

If option \code{"StartupBanner"} is not defined (default) or setting    
\code{options("StartupBanner"=NULL)} or  \code{options("StartupBanner"="complete")} 
the complete start-up banner is displayed.

For any other value of option \code{"StartupBanner"} (i.e., not in \code{c(NULL,"off","complete")})
only the version information is displayed.

As for general \code{packageStartupMessage}'s, you may also suppress all
 the start-up banner by wrapping the \code{library} or \code{require} 
 call into \code{suppressPackageStartupMessages()} from 
 \pkg{startupmsg}-version 0.5 on.
 }

\section{Package versions}{
Note: The first two numbers of package versions do not necessarily reflect
 package-individual development, but rather are chosen for the
 distrXXX family as a whole in order to ease updating "depends"
 information.
}

\keyword{ package }
\concept{contaminated data}
\concept{contaminating data}
\concept{ideal data}
\concept{simulation}
\concept{S4 simulation class}
\concept{S4 data class}
\seealso{
\code{\link[distr:0distr-package]{distr-package}} \code{\link[setRNG]{setRNG}} 
}
