% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_aggregate.R
\name{zoo_aggregate}
\alias{zoo_aggregate}
\title{Aggregate Cases in Zoo Time Series}
\usage{
zoo_aggregate(x = NULL, new_time = NULL, f = mean, ...)
}
\arguments{
\item{x}{(required, zoo object) Time series to aggregate. Default: NULL}

\item{new_time}{(optional, zoo object, keyword, or time vector) New time to aggregate \code{x} to. The available options are:
\itemize{
\item NULL: the highest resolution keyword returned by \code{zoo_time(x)$keywords} is used to generate a new time vector to aggregate \code{x}.
\item zoo object: the index of the given zoo object is used as template to aggregate \code{x}.
\item time vector: a vector with new times to resample \code{x} to. If time in \code{x} is of class "numeric", this vector must be numeric as well. Otherwise, vectors of classes "Date" and "POSIXct" can be used indistinctly.
\item keyword: a valid keyword returned by \code{zoo_time(x)$keywords}, used to generate a time vector with the relevant units.
\item numeric of length 1: interpreted as new time interval, in the highest resolution units returned by \code{zoo_time(x)$units}.
}}

\item{f}{(optional, quoted or unquoted function name) Name of a standard or custom function to aggregate numeric vectors. Typical examples are \code{mean}, \code{max},\code{min}, \code{median}, and \code{quantile}. Default: \code{mean}.}

\item{...}{(optional, additional arguments) additional arguments to \code{f}.}
}
\value{
zoo object
}
\description{
Aggregate Cases in Zoo Time Series
}
\examples{
#full range of calendar dates
x <- zoo_simulate(
  rows = 1000,
  time_range = c(
    "0000-01-01",
    as.character(Sys.Date())
    )
)

#plot time series
if(interactive()){
  zoo_plot(x)
}


#find valid aggregation keywords
x_time <- zoo_time(x)
x_time$keywords

#mean value by millennia (extreme case!!!)
x_millennia <- zoo_aggregate(
  x = x,
  new_time = "millennia",
  f = mean
)

if(interactive()){
  zoo_plot(x_millennia)
}

#max value by centuries
x_centuries <- zoo_aggregate(
  x = x,
  new_time = "centuries",
  f = max
)

if(interactive()){
  zoo_plot(x_centuries)
}

#quantile 0.75 value by centuries
x_centuries <- zoo_aggregate(
  x = x,
  new_time = "centuries",
  f = stats::quantile,
  probs = 0.75 #argument of stats::quantile()
)

if(interactive()){
  zoo_plot(x_centuries)
}
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
