# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' (C++) Sum Distances Between Consecutive Samples in a Time Series
#' @description Computes the cumulative sum of distances between consecutive
#' samples in a univariate or multivariate time series.
#' NA values should be removed before using this function.
#' @param x (required, numeric matrix) univariate or multivariate time series.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean"
#' @return numeric
#' @examples
#' #simulate a time series
#' x <- zoo_simulate()
#'
#' #compute auto distance
#' auto_distance_cpp(
#'   x = x,
#'   distance = "euclidean"
#'   )
#' @export
#' @family Rcpp_auto_sum
auto_distance_cpp <- function(x, distance = "euclidean") {
    .Call(`_distantia_auto_distance_cpp`, x, distance)
}

#' (C++) Subset Matrix by Rows
#' @description Subsets a time series matrix to the coordinates of a trimmed
#' least-cost path when blocks are ignored during a dissimilarity analysis.
#' @param m (required, numeric matrix) a univariate or multivariate time series.
#' @param rows (required, integer vector) vector of rows to subset from a
#' least-cost path data frame.
#' @return numeric matrix
#' @examples
#' #simulate a time series
#' m <- zoo_simulate(seed = 1)
#'
#' #sample some rows
#' rows <- sample(
#'   x = nrow(m),
#'   size = 10
#'   ) |>
#'   sort()
#'
#' #subset by rows
#' m_subset <- subset_matrix_by_rows_cpp(
#'   m = m,
#'   rows = rows
#'   )
#'
#' #compare with original
#' m[rows, ]
#'
#' @export
#' @family Rcpp_auto_sum
subset_matrix_by_rows_cpp <- function(m, rows) {
    .Call(`_distantia_subset_matrix_by_rows_cpp`, m, rows)
}

#' (C++) Sum Distances Between All Consecutive Samples in Two Time Series
#' @description Computes the cumulative auto sum of autodistances of two time series.
#' The output value is used as normalization factor when computing dissimilarity scores.
#' @param x (required, numeric matrix) univariate or multivariate time series.
#' @param y (required, numeric matrix) univariate or multivariate time series
#' with the same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean"
#' @return numeric
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #auto sum
#' auto_sum_full_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#' @export
#' @family Rcpp_auto_sum
auto_sum_full_cpp <- function(x, y, distance = "euclidean") {
    .Call(`_distantia_auto_sum_full_cpp`, x, y, distance)
}

#' (C++) Sum Distances Between All Consecutive Samples in the Least Cost Path Between Two Time Series
#' @description Computes the cumulative auto sum of auto-distances of two time series
#' for the coordinates of a trimmed least cost path. The output value is used
#' as normalization factor when computing dissimilarity scores.
#' @param x (required, numeric matrix) univariate or multivariate time series.
#' @param y (required, numeric matrix) univariate or multivariate time series
#' with the same number of columns as 'x'.
#' @param path (required, data frame) least-cost path produced by [cost_path_orthogonal_cpp()].
#' Default: NULL
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @return numeric
#' @export
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_orthogonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' nrow(cost_path)
#'
#' #remove blocks from least-cost path
#' cost_path_trimmed <- cost_path_trim_cpp(
#'   path = cost_path
#' )
#'
#' nrow(cost_path_trimmed)
#'
#' #auto sum
#' auto_sum_path_cpp(
#'   x = x,
#'   y = y,
#'   path = cost_path_trimmed,
#'   distance = "euclidean"
#' )
#' @export
#' @family Rcpp_auto_sum
auto_sum_path_cpp <- function(x, y, path, distance = "euclidean") {
    .Call(`_distantia_auto_sum_path_cpp`, x, y, path, distance)
}

#' (C++) Sum Distances Between Consecutive Samples in Two Time Series
#' @description Sum of auto-distances of two time series.
#' This function switches between [auto_sum_full_cpp()] and [auto_sum_path_cpp()]
#' depending on the value of the argument `ignore_blocks`.
#' @param x (required, numeric matrix) of same number of columns as 'y'.
#' @param y (required, numeric matrix) of same number of columns as 'x'.
#' @param path (required, data frame) output of [cost_path_orthogonal_cpp()].
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean"
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.
#' @return numeric
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_orthogonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' nrow(cost_path)
#'
#' #remove blocks from least-cost path
#' cost_path_trimmed <- cost_path_trim_cpp(
#'   path = cost_path
#' )
#'
#' nrow(cost_path_trimmed)
#'
#' #auto sum
#' auto_sum_cpp(
#'   x = x,
#'   y = y,
#'   path = cost_path_trimmed,
#'   distance = "euclidean",
#'   ignore_blocks = FALSE
#' )
#' @export
#' @family Rcpp_auto_sum
auto_sum_cpp <- function(x, y, path, distance = "euclidean", ignore_blocks = FALSE) {
    .Call(`_distantia_auto_sum_cpp`, x, y, path, distance, ignore_blocks)
}

#' (C++) Compute Orthogonal and Diagonal Least Cost Matrix from a Distance Matrix
#' @description Computes the least cost matrix from a distance matrix.
#' Considers diagonals during computation of least-costs.
#' @param dist_matrix (required, distance matrix). Square distance matrix, output of [distance_matrix_cpp()].
#' @return Least cost matrix.
#' @export
#' @family Rcpp_matrix
cost_matrix_diagonal_cpp <- function(dist_matrix) {
    .Call(`_distantia_cost_matrix_diagonal_cpp`, dist_matrix)
}

#' (C++) Compute Orthogonal and Weighted Diagonal Least Cost Matrix from a Distance Matrix
#' @description Computes the least cost matrix from a distance matrix.
#' Weights diagonals by a factor of 1.414214 (square root of 2) with respect to orthogonal paths.
#' @param dist_matrix (required, distance matrix). Distance matrix.
#' @return Least cost matrix.
#' @export
#' @family Rcpp_matrix
cost_matrix_diagonal_weighted_cpp <- function(dist_matrix) {
    .Call(`_distantia_cost_matrix_diagonal_weighted_cpp`, dist_matrix)
}

#' (C++) Compute Orthogonal Least Cost Matrix from a Distance Matrix
#' @description Computes the least cost matrix from a distance matrix.
#' @param dist_matrix (required, distance matrix). Output of [distance_matrix_cpp()].
#' @return Least cost matrix.
#' @export
#' @family Rcpp_matrix
cost_matrix_orthogonal_cpp <- function(dist_matrix) {
    .Call(`_distantia_cost_matrix_orthogonal_cpp`, dist_matrix)
}

#' (C++) Least Cost Path for Sequence Slotting
#' @description Computes a least-cost matrix from a distance matrix.
#' This version differs from [cost_path_orthogonal_cpp()] in the way it solves ties.
#' In the case of a tie, [cost_path_orthogonal_cpp()] uses the first neighbor satisfying
#' the minimum distance condition, while this function selects the neighbor
#' that changes the axis of movement within the least-cost matrix. This function
#' is not used anywhere within the package, but was left here for future reference.
#' @param dist_matrix (required, numeric matrix). Distance matrix between two
#' time series.
#' @param cost_matrix (required, numeric matrix). Least-cost matrix generated from
#' `dist_matrix`.
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_slotting_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path
#' @export
#' @family Rcpp_cost_path
cost_path_slotting_cpp <- function(dist_matrix, cost_matrix) {
    .Call(`_distantia_cost_path_slotting_cpp`, dist_matrix, cost_matrix)
}

#' (C++) Orthogonal Least Cost Path
#' @description
#' Computes an orthogonal least-cost path within a cost matrix. Each steps within
#' the least-cost path either moves in the x or the y direction, but never diagonally.
#' @param dist_matrix (required, numeric matrix). Distance matrix between two
#' time series.
#' @param cost_matrix (required, numeric matrix). Cost matrix generated from
#' `dist_matrix`.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_orthogonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path
#' @export
#' @family Rcpp_cost_path
cost_path_orthogonal_bandwidth_cpp <- function(dist_matrix, cost_matrix, bandwidth = 1) {
    .Call(`_distantia_cost_path_orthogonal_bandwidth_cpp`, dist_matrix, cost_matrix, bandwidth)
}

#' (C++) Orthogonal Least Cost Path
#' @description
#' Computes an orthogonal least-cost path within a cost matrix. Each steps within
#' the least-cost path either moves in the x or the y direction, but never diagonally.
#' @param dist_matrix (required, numeric matrix). Distance matrix between two
#' time series.
#' @param cost_matrix (required, numeric matrix). Cost matrix generated from
#' `dist_matrix`.
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_orthogonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path
#' @export
#' @family Rcpp_cost_path
cost_path_orthogonal_cpp <- function(dist_matrix, cost_matrix) {
    .Call(`_distantia_cost_path_orthogonal_cpp`, dist_matrix, cost_matrix)
}

#' (C++) Orthogonal and Diagonal Least Cost Path Restricted by Sakoe-Chiba band
#' @description Computes the least cost matrix from a distance matrix.
#' Considers diagonals during computation of least-costs. In case of ties,
#' diagonals are favored.
#' @param dist_matrix (required, numeric matrix). Distance matrix between two
#' time series.
#' @param cost_matrix (required, numeric matrix). Cost matrix generated from
#' `dist_matrix`.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_diagonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path
#' @export
#' @family Rcpp_cost_path
cost_path_diagonal_bandwidth_cpp <- function(dist_matrix, cost_matrix, bandwidth = 1) {
    .Call(`_distantia_cost_path_diagonal_bandwidth_cpp`, dist_matrix, cost_matrix, bandwidth)
}

#' (C++) Orthogonal and Diagonal Least Cost Path
#' @description Computes the least cost matrix from a distance matrix.
#' Considers diagonals during computation of least-costs. In case of ties,
#' diagonals are favored.
#' @param dist_matrix (required, numeric matrix). Distance matrix between two
#' time series.
#' @param cost_matrix (required, numeric matrix). Cost matrix generated from
#' `dist_matrix`.
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_diagonal_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path
#' @export
#' @family Rcpp_cost_path
cost_path_diagonal_cpp <- function(dist_matrix, cost_matrix) {
    .Call(`_distantia_cost_path_diagonal_cpp`, dist_matrix, cost_matrix)
}

#' (C++) Remove Blocks from a Least Cost Path
#' @param path (required, data frame) least-cost path produced by [cost_path_orthogonal_cpp()].
#' @return data frame
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_slotting_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' nrow(cost_path)
#'
#' #remove blocks from least-cost path
#' cost_path_trimmed <- cost_path_trim_cpp(
#'   path = cost_path
#' )
#'
#' nrow(cost_path_trimmed)
#' @export
#' @family Rcpp_cost_path
cost_path_trim_cpp <- function(path) {
    .Call(`_distantia_cost_path_trim_cpp`, path)
}

#' (C++) Sum Distances in a Least Cost Path
#' @param path (required, data frame) least-cost path produced by [cost_path_orthogonal_cpp()].
#' @return numeric
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' #least cost matrix
#' cost_matrix <- cost_matrix_orthogonal_cpp(
#'   dist_matrix = dist_matrix
#' )
#'
#' #least cost path
#' cost_path <- cost_path_slotting_cpp(
#'   dist_matrix = dist_matrix,
#'   cost_matrix = cost_matrix
#' )
#'
#' cost_path_sum_cpp(
#'   path = cost_path
#'   )
#' @export
#' @family Rcpp_cost_path
cost_path_sum_cpp <- function(path) {
    .Call(`_distantia_cost_path_sum_cpp`, path)
}

#' Least Cost Path
#' @description Least cost path between two time series \code{x} and \code{y}.
#' NA values must be removed from \code{x} and \code{y} before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param x (required, numeric matrix) multivariate time series.
#' @param y (required, numeric matrix) multivariate time series
#' with the same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param diagonal (optional, logical). If TRUE, diagonals are included in the
#' computation of the cost matrix. Default: FALSE.
#' @param weighted (optional, logical). If TRUE, diagonal is set to TRUE, and
#' diagonal cost is weighted by y factor of 1.414214 (square root of 2). Default: FALSE.
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @return data frame
#' @export
#' @family Rcpp_cost_path
cost_path_cpp <- function(x, y, distance = "euclidean", diagonal = TRUE, weighted = TRUE, ignore_blocks = FALSE, bandwidth = 1) {
    .Call(`_distantia_cost_path_cpp`, x, y, distance, diagonal, weighted, ignore_blocks, bandwidth)
}

#' (C++) Distance Matrix of Two Time Series
#' @description Computes the distance matrix between the rows of two matrices
#' \code{y} and \code{x} representing regular or irregular time series with the same number of
#' columns. NA values should be removed before using this function. If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param x (required, numeric matrix) univariate or multivariate time series.
#' @param y (required, numeric matrix) univariate or multivariate time series
#' with the same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @return numeric matrix
#' @examples
#' #simulate two time series
#' x <- zoo_simulate(seed = 1)
#' y <- zoo_simulate(seed = 2)
#'
#' #distance matrix
#' dist_matrix <- distance_matrix_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#' @export
#' @family Rcpp_matrix
#' @name distance_matrix_cpp
distance_matrix_cpp <- function(x, y, distance = "euclidean") {
    .Call(`_distantia_distance_matrix_cpp`, x, y, distance)
}

#' (C++) Sum of Pairwise Distances Between Cases in Two Aligned Time Series
#' @description Computes the lock-step sum of distances between two regular
#' and aligned time series. NA values should be removed before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param x (required, numeric matrix) univariate or multivariate time series.
#' @param y (required, numeric matrix) univariate or multivariate time series
#' with the same number of columns and rows as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @return numeric
#' @examples
#' #simulate two regular time series
#' x <- zoo_simulate(
#'   seed = 1,
#'   irregular = FALSE
#'   )
#' y <- zoo_simulate(
#'   seed = 2,
#'   irregular = FALSE
#'   )
#'
#' #distance matrix
#' dist_matrix <- distance_ls_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#' @export
#' @family Rcpp_matrix
distance_ls_cpp <- function(x, y, distance = "euclidean") {
    .Call(`_distantia_distance_ls_cpp`, x, y, distance)
}

#' (C++) Chebyshev Distance Between Two Vectors
#' @description Computed as: \code{max(abs(x - y))}. Cannot handle NA values.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_chebyshev_cpp(x = runif(100), y = runif(100))
#' @export
#' @family Rcpp_distance_methods
distance_chebyshev_cpp <- function(x, y) {
    .Call(`_distantia_distance_chebyshev_cpp`, x, y)
}

#' (C++) Jaccard Distance Between Two Binary Vectors
#' @description Computes the Jaccard distance between two binary vectors.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_jaccard_cpp(x = c(0, 1, 0, 1), y = c(1, 1, 0, 0))
#' @export
#' @family Rcpp_distance_methods
distance_jaccard_cpp <- function(x, y) {
    .Call(`_distantia_distance_jaccard_cpp`, x, y)
}

#' (C++) Manhattan Distance Between Two Vectors
#' @description Computed as: \code{sum(abs(x - y))}. Cannot handle NA values.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_manhattan_cpp(x = runif(100), y = runif(100))
#' @export
#' @family Rcpp_distance_methods
distance_manhattan_cpp <- function(x, y) {
    .Call(`_distantia_distance_manhattan_cpp`, x, y)
}

#' (C++) Euclidean Distance Between Two Vectors
#' @description Computed as: \code{sqrt(sum((x - y)^2)}. Cannot handle NA values.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_euclidean_cpp(x = runif(100), y = runif(100))
#' @export
#' @family Rcpp_distance_methods
distance_euclidean_cpp <- function(x, y) {
    .Call(`_distantia_distance_euclidean_cpp`, x, y)
}

#' (C++) Hellinger Distance Between Two Vectors
#' @description Computed as: \code{sqrt(1/2 * sum((sqrt(x) - sqrt(y))^2))}.
#' Cannot handle NA values.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_hellinger_cpp(x = runif(100), y = runif(100))
#' @export
#' @family Rcpp_distance_methods
distance_hellinger_cpp <- function(x, y) {
    .Call(`_distantia_distance_hellinger_cpp`, x, y)
}

#' (C++) Normalized Chi Distance Between Two Vectors
#' @description Computed as:
#' \code{xy <- x + y}
#' \code{y. <- y / sum(y)}
#' \code{x. <- x / sum(x)}
#' \code{sqrt(sum(((x. - y.)^2) / (xy / sum(xy))))}.
#' Cannot handle NA values. When \code{x} and \code{y} have zeros in the same
#' position, \code{NaNs} are produced. Please replace these zeros with
#' pseudo-zeros (i.e. 0.0001) if you wish to use this distance metric.
#' @examples distance_chi_cpp(x = runif(100), y = runif(100))
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @export
#' @family Rcpp_distance_methods
distance_chi_cpp <- function(x, y) {
    .Call(`_distantia_distance_chi_cpp`, x, y)
}

#' (C++) Canberra Distance Between Two Binary Vectors
#' @description Computes the Canberra distance between two binary vectors.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_canberra_cpp(c(0, 1, 0, 1), c(1, 1, 0, 0))
#' @export
#' @family Rcpp_distance_methods
distance_canberra_cpp <- function(x, y) {
    .Call(`_distantia_distance_canberra_cpp`, x, y)
}

#' (C++) Russell-Rao Distance Between Two Binary Vectors
#' @description Computes the Russell-Rao distance between two binary vectors.
#' @param x (required, numeric). Binary vector of 1s and 0s.
#' @param y (required, numeric) Binary vector of 1s and 0s of same length as `x`.
#' @return numeric
#' @examples distance_russelrao_cpp(c(0, 1, 0, 1), c(1, 1, 0, 0))
#' @export
#' @family Rcpp_distance_methods
distance_russelrao_cpp <- function(x, y) {
    .Call(`_distantia_distance_russelrao_cpp`, x, y)
}

#' (C++) Cosine Dissimilarity Between Two Vectors
#' @description Computes the cosine dissimilarity between two numeric vectors.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_cosine_cpp(c(0.2, 0.4, 0.5), c(0.1, 0.8, 0.2))
#' @export
#' @family Rcpp_distance_methods
distance_cosine_cpp <- function(x, y) {
    .Call(`_distantia_distance_cosine_cpp`, x, y)
}

#' (C++) Hamming Distance Between Two Binary Vectors
#' @description Computes the Hamming distance between two binary vectors.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_hamming_cpp(c(0, 1, 0, 1), c(1, 1, 0, 0))
#' @export
#' @family Rcpp_distance_methods
distance_hamming_cpp <- function(x, y) {
    .Call(`_distantia_distance_hamming_cpp`, x, y)
}

#' (C++) Bray-Curtis Distance Between Two Vectors
#' @description Computes the Bray-Curtis distance, suitable for species abundance data.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_bray_curtis_cpp(x = runif(100), y = runif(100))
#' @export
#' @family Rcpp_distance_methods
distance_bray_curtis_cpp <- function(x, y) {
    .Call(`_distantia_distance_bray_curtis_cpp`, x, y)
}

#' (C++) Sørensen Distance Between Two Binary Vectors
#' @description Computes the Sørensen distance, suitable for presence/absence data.
#' @param x (required, numeric vector).
#' @param y (required, numeric vector) of same length as `x`.
#' @return numeric
#' @examples distance_sorensen_cpp(x = c(0, 1, 1, 0), y = c(1, 1, 0, 0))
#' @export
#' @family Rcpp_distance_methods
distance_sorensen_cpp <- function(x, y) {
    .Call(`_distantia_distance_sorensen_cpp`, x, y)
}

update_path_dist_cpp <- function(x, y, path, distance = "euclidean") {
    .Call(`_distantia_update_path_dist_cpp`, x, y, path, distance)
}

select_column_cpp <- function(x, column_index) {
    .Call(`_distantia_select_column_cpp`, x, column_index)
}

delete_column_cpp <- function(x, column_index) {
    .Call(`_distantia_delete_column_cpp`, x, column_index)
}

#' (C++) Contribution of Individual Variables to the Dissimilarity Between Two Aligned Time Series
#' @description Computes the contribution of individual variables to the
#' similarity/dissimilarity between two aligned multivariate time series.
#' This function generates a data frame with the following columns:
#' \itemize{
#'   \item variable: name of the individual variable for which the importance
#'   is being computed, from the column names of the arguments `x` and `y`.
#'   \item psi: global dissimilarity score `psi` of the two time series.
#'   \item psi_only_with: dissimilarity between `x` and `y` computed from the given variable alone.
#'   \item psi_without: dissimilarity between `x` and `y` computed from all other variables.
#'   \item psi_difference: difference between `psi_only_with` and `psi_without`.
#'   \item importance: contribution of the variable to the similarity/dissimilarity
#'   between `x` and `y`, computed as `(psi_difference * 100) / psi_all`.
#'   Positive scores represent contribution to dissimilarity,
#'   while negative scores represent contribution to similarity.
#' }
#' @param x (required, numeric matrix) multivariate time series.
#' @param y (required, numeric matrix) multivariate time series
#' with the same number of columns and rows as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @return data frame
#' @examples
#' #simulate two regular time series
#' x <- zoo_simulate(
#'   seed = 1,
#'   irregular = FALSE
#'   )
#'
#' y <- zoo_simulate(
#'   seed = 2,
#'   irregular = FALSE
#'   )
#'
#' #same number of rows
#' nrow(x) == nrow(y)
#'
#' #compute importance
#' df <- importance_ls_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' df
#' @family Rcpp_importance
#' @export
importance_ls_cpp <- function(x, y, distance = "euclidean") {
    .Call(`_distantia_importance_ls_cpp`, x, y, distance)
}

#' (C++) Contribution of Individual Variables to the Dissimilarity Between Two Time Series (Legacy Version)
#' @description Computes the contribution of individual variables to the
#' similarity/dissimilarity between two irregular multivariate time series.
#' In opposition to the robust version, least-cost paths for each combination
#' of variables are computed independently, which makes the results of individual
#' variables harder to compare. This function should only be used when the objective is
#' replicating importance scores generated with previous versions of the package `distantia`.
#' This function generates a data frame with the following columns:
#' \itemize{
#'   \item variable: name of the individual variable for which the importance
#'   is being computed, from the column names of the arguments `x` and `y`.
#'   \item psi: global dissimilarity score `psi` of the two time series.
#'   \item psi_only_with: dissimilarity between `x` and `y` computed from the given variable alone.
#'   \item psi_without: dissimilarity between `x` and `y` computed from all other variables.
#'   \item psi_difference: difference between `psi_only_with` and `psi_without`.
#'   \item importance: contribution of the variable to the similarity/dissimilarity
#'   between `x` and `y`, computed as `((psi_all - psi_without) * 100) / psi_all`.
#'   Positive scores represent contribution to dissimilarity,
#'   while negative scores represent contribution to similarity.
#' }
#' @param x (required, numeric matrix) multivariate time series.
#' @param y (required, numeric matrix) multivariate time series
#' with the same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param diagonal (optional, logical). If TRUE, diagonals are included in the
#' computation of the cost matrix. Default: FALSE.
#' @param weighted (optional, logical). If TRUE, diagonal is set to TRUE, and
#' diagonal cost is weighted by a factor of 1.414214 (square root of 2). Default: FALSE.
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @return data frame
#' @examples
#' #simulate two regular time series
#' x <- zoo_simulate(
#'   seed = 1,
#'   rows = 100
#'   )
#'
#' y <- zoo_simulate(
#'   seed = 2,
#'   rows = 150
#'   )
#'
#' #different number of rows
#' #this is not a requirement though!
#' nrow(x) == nrow(y)
#'
#' #compute importance
#' df <- importance_dtw_legacy_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' df
#' @family Rcpp_importance
#' @export
importance_dtw_legacy_cpp <- function(y, x, distance = "euclidean", diagonal = FALSE, weighted = TRUE, ignore_blocks = FALSE, bandwidth = 1) {
    .Call(`_distantia_importance_dtw_legacy_cpp`, y, x, distance, diagonal, weighted, ignore_blocks, bandwidth)
}

#' (C++) Contribution of Individual Variables to the Dissimilarity Between Two Time Series (Robust Version)
#' @description Computes the contribution of individual variables to the
#' similarity/dissimilarity between two irregular multivariate time series.
#' In opposition to the legacy version, importance computation is
#' performed taking the least-cost path of the whole sequence as reference. This
#' operation makes the importance scores of individual variables fully comparable.
#' This function generates a data frame with the following columns:
#' \itemize{
#'   \item variable: name of the individual variable for which the importance
#'   is being computed, from the column names of the arguments `x` and `y`.
#'   \item psi: global dissimilarity score `psi` of the two time series.
#'   \item psi_only_with: dissimilarity between `x` and `y` computed from the given variable alone.
#'   \item psi_without: dissimilarity between `x` and `y` computed from all other variables.
#'   \item psi_difference: difference between `psi_only_with` and `psi_without`.
#'   \item importance: contribution of the variable to the similarity/dissimilarity
#'   between `x` and `y`, computed as `(psi_difference * 100) / psi_all`.
#'   Positive scores represent contribution to dissimilarity,
#'   while negative scores represent contribution to similarity.
#' }
#' @param x (required, numeric matrix) multivariate time series.
#' @param y (required, numeric matrix) multivariate time series
#' with the same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param diagonal (optional, logical). If TRUE, diagonals are included in the
#' computation of the cost matrix. Default: TRUE.
#' @param weighted (optional, logical). If TRUE, diagonal is set to TRUE, and
#' diagonal cost is weighted by a factor of 1.414214 (square root of 2). Default: TRUE.
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @return data frame
#' @examples
#' #simulate two regular time series
#' x <- zoo_simulate(
#'   seed = 1,
#'   rows = 100
#'   )
#'
#' y <- zoo_simulate(
#'   seed = 2,
#'   rows = 150
#'   )
#'
#' #different number of rows
#' #this is not a requirement though!
#' nrow(x) == nrow(y)
#'
#' #compute importance
#' df <- importance_dtw_cpp(
#'   x = x,
#'   y = y,
#'   distance = "euclidean"
#' )
#'
#' df
#' @family Rcpp_importance
#' @export
importance_dtw_cpp <- function(x, y, distance = "euclidean", diagonal = TRUE, weighted = TRUE, ignore_blocks = FALSE, bandwidth = 1) {
    .Call(`_distantia_importance_dtw_cpp`, x, y, distance, diagonal, weighted, ignore_blocks, bandwidth)
}

#' (C++) Restricted Permutation of Complete Rows Within Blocks
#' @description Divides a sequence in blocks of a given size and permutes rows
#' within these blocks.
#' Larger block sizes increasingly disrupt the data structure over time.
#' @param x (required, numeric matrix). Numeric matrix to permute.
#' @param block_size (optional, integer) block size in number of rows.
#' Minimum value is 2, and maximum value is nrow(x).
#' @param seed (optional, integer) random seed to use.
#' @return numeric matrix
#' @family Rcpp_permutation
#' @export
permute_restricted_by_row_cpp <- function(x, block_size, seed = 1L) {
    .Call(`_distantia_permute_restricted_by_row_cpp`, x, block_size, seed)
}

#' (C++) Unrestricted Permutation of Complete Rows
#' @description Unrestricted shuffling of rows within the whole sequence.
#' @param x (required, numeric matrix). Numeric matrix to permute.
#' @param block_size (optional, integer) this function ignores this argument and sets it to x.nrow().
#' @param seed (optional, integer) random seed to use.
#' @return numeric matrix
#' @family Rcpp_permutation
#' @export
permute_free_by_row_cpp <- function(x, block_size, seed = 1L) {
    .Call(`_distantia_permute_free_by_row_cpp`, x, block_size, seed)
}

#' (C++) Restricted Permutation of Cases Within Blocks
#' @description Divides a sequence or time series in blocks and permutes cases
#' within these blocks. This function does not preserve rows, and should not be
#' used if the sequence has dependent columns.
#' Larger block sizes increasingly disrupt the data structure over time.
#' @param x (required, numeric matrix). Numeric matrix to permute.
#' @param block_size (optional, integer) block size in number of rows.
#' Minimum value is 2, and maximum value is nrow(x).
#' @param seed (optional, integer) random seed to use.
#' @return numeric matrix
#' @family Rcpp_permutation
#' @export
permute_restricted_cpp <- function(x, block_size, seed = 1L) {
    .Call(`_distantia_permute_restricted_cpp`, x, block_size, seed)
}

#' (C++) Unrestricted Permutation of Cases
#' @description Unrestricted shuffling of cases within the whole sequence.
#' @param x (required, numeric matrix). Numeric matrix to permute.
#' @param block_size (optional, integer) this function ignores this argument and sets it to x.nrow().
#' @param seed (optional, integer) random seed to use.
#' @return numeric matrix
#' @family Rcpp_permutation
#' @export
permute_free_cpp <- function(x, block_size, seed = 1L) {
    .Call(`_distantia_permute_free_cpp`, x, block_size, seed)
}

#' (C++) Equation of the Psi Dissimilarity Score
#' @description Equation to compute the `psi` dissimilarity score
#' (Birks and Gordon 1985). Psi is computed as \eqn{\psi = (2a / b) - 1},
#' where \eqn{a} is the sum of distances between the relevant samples of two
#' time series, and \eqn{b} is the cumulative sum of distances between
#' consecutive samples in the two time series.
#' If `a` is computed with dynamic time warping, and diagonals are used in the
#' computation of the least cost path, then one is added to the result of the equation above.
#' @param a (required, numeric) output of [cost_path_sum_cpp()] on a least cost path.
#' @param b (required, numeric) auto sum of both sequences,
#' result of [auto_sum_cpp()].
#' @param diagonal (optional, logical). Must be TRUE when diagonals are used in
#' dynamic time warping and for lock-step distances. Default: FALSE.
#' @return numeric
#' @family Rcpp_dissimilarity_analysis
#' @export
psi_equation_cpp <- function(a, b, diagonal = TRUE) {
    .Call(`_distantia_psi_equation_cpp`, a, b, diagonal)
}

#' (C++) Psi Dissimilarity Score of Two Aligned Time Series
#' @description Computes the psi dissimilarity score between two time series
#' observed at the same times. Time series \code{y} and \code{x} with the same
#' number of columns and rows. NA values should be removed before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param x (required, numeric matrix) of same number of columns as 'y'.
#' @param y (required, numeric matrix) of same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @return numeric
#' @family Rcpp_dissimilarity_analysis
#' @export
psi_ls_cpp <- function(x, y, distance = "euclidean") {
    .Call(`_distantia_psi_ls_cpp`, x, y, distance)
}

#' (C++) Null Distribution of the Dissimilarity Scores of Two Aligned Time Series
#' @description Applies permutation methods to compute null distributions for
#' the psi scores of two time series observed at the same times.
#' NA values should be removed before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param x (required, numeric matrix) of same number of columns as 'y'.
#' @param y (required, numeric matrix) of same number of columns as 'x'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param repetitions (optional, integer) number of null psi values to generate. Default: 100
#' @param permutation (optional, character) permutation method. Valid values are listed below from higher to lower randomness:
#' \itemize{
#'   \item "free": unrestricted shuffling of rows and columns. Ignores block_size.
#'   \item "free_by_row": unrestricted shuffling of complete rows. Ignores block size.
#'   \item "restricted": restricted shuffling of rows and columns within blocks.
#'   \item "restricted_by_row": restricted shuffling of rows within blocks.
#' }
#' @param block_size (optional, integer) block size in rows for
#' restricted permutation. A block size of 3 indicates that a row can only be permuted
#' within a block of 3 adjacent rows. Minimum value is 2. Default: 3.
#' @param seed (optional, integer) initial random seed to use for replicability. Default: 1
#' @return numeric vector
#' @family Rcpp_dissimilarity_analysis
#' @export
psi_null_ls_cpp <- function(x, y, distance = "euclidean", repetitions = 100L, permutation = "restricted_by_row", block_size = 3L, seed = 1L) {
    .Call(`_distantia_psi_null_ls_cpp`, x, y, distance, repetitions, permutation, block_size, seed)
}

#' (C++) Psi Dissimilarity Score of Two Time-Series
#' @description Computes the psi score of two time series \code{y} and \code{x}
#' with the same number of columns.
#' NA values should be removed before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param y (required, numeric matrix) time series.
#' @param x (required, numeric matrix) of same number of columns as 'y'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param diagonal (optional, logical). If TRUE, diagonals are included in the
#' computation of the cost matrix. Default: FALSE.
#' @param weighted (optional, logical). If TRUE, diagonal is set to TRUE, and
#' diagonal cost is weighted by a factor of 1.414214 (square root of 2). Default: FALSE.
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. Default: FALSE.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' @return numeric
#' @family Rcpp_dissimilarity_analysis
#' @export
psi_dtw_cpp <- function(x, y, distance = "euclidean", diagonal = TRUE, weighted = TRUE, ignore_blocks = FALSE, bandwidth = 1) {
    .Call(`_distantia_psi_dtw_cpp`, x, y, distance, diagonal, weighted, ignore_blocks, bandwidth)
}

#' (C++) Null Distribution of Dissimilarity Scores of Two Time Series
#' @description Applies permutation methods to compute null distributions for
#' the psi scores of two time series.
#' NA values should be removed before using this function.
#' If the selected distance function is "chi" or "cosine", pairs of zeros should
#' be either removed or replaced with pseudo-zeros (i.e. 0.00001).
#' @param y (required, numeric matrix).
#' @param x (required, numeric matrix) of same number of columns as 'y'.
#' @param distance (optional, character string) distance name from the "names"
#' column of the dataset `distances` (see `distances$name`). Default: "euclidean".
#' @param diagonal (optional, logical). If TRUE, diagonals are included in the
#' computation of the cost matrix. Default: FALSE.
#' @param weighted (optional, logical). If TRUE, diagonal is set to TRUE, and
#' diagonal cost is weighted by a factor of 1.414214 (square root of 2). Default: FALSE.
#' @param ignore_blocks (optional, logical). If TRUE, blocks of consecutive path
#' coordinates are trimmed to avoid inflating the psi distance. This argument
#' has nothing to do with block_size!. Default: FALSE.
#' @param bandwidth (required, numeric) Size of the Sakoe-Chiba band at
#' both sides of the diagonal used to constrain the least cost path. Expressed
#' as a fraction of the number of matrix rows and columns. Unrestricted by default.
#' Default: 1
#' @param repetitions (optional, integer) number of null psi values to generate. Default: 100
#' @param permutation (optional, character) permutation method. Valid values are listed below from higher to lower randomness:
#' \itemize{
#'   \item "free": unrestricted shuffling of rows and columns. Ignores block_size.
#'   \item "free_by_row": unrestricted shuffling of complete rows. Ignores block size.
#'   \item "restricted": restricted shuffling of rows and columns within blocks.
#'   \item "restricted_by_row": restricted shuffling of rows within blocks.
#' }
#' @param block_size (optional, integer) block size in rows for
#' restricted permutation. A block size of 3 indicates that a row can only be permuted
#' within a block of 3 adjacent rows. Minimum value is 2. Default: 3.
#' @param seed (optional, integer) initial random seed to use for replicability. Default: 1
#' @return numeric vector
#' @family Rcpp_dissimilarity_analysis
#' @export
psi_null_dtw_cpp <- function(x, y, distance = "euclidean", diagonal = TRUE, weighted = TRUE, ignore_blocks = FALSE, bandwidth = 1, repetitions = 100L, permutation = "restricted_by_row", block_size = 3L, seed = 1L) {
    .Call(`_distantia_psi_null_dtw_cpp`, x, y, distance, diagonal, weighted, ignore_blocks, bandwidth, repetitions, permutation, block_size, seed)
}

