% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatrix.R
\name{plotMatrix}
\alias{plotMatrix}
\title{Plots distance matrices and least cost paths.}
\usage{
plotMatrix(
  distance.matrix = NULL,
  least.cost.path = NULL,
  plot.columns = NULL,
  plot.rows = NULL,
  legend = TRUE,
  color.palette = "divergent",
  path.color = "black",
  path.width = 1,
  margins = c(2,3,2,4),
  pdf.filename = NULL,
  pdf.width = 7,
  pdf.height = 4,
  pdf.pointsize = 12,
  rotate = FALSE
  )
}
\arguments{
\item{distance.matrix}{numeric matrix or list of numeric matrices either produced by \code{\link{distanceMatrix}} or \code{\link{leastCostMatrix}}.}

\item{least.cost.path}{dataframe or list of fdataframes produced by \code{\link{leastCostPath}}. If a list, must have the same number of slots as \code{distance.matrix}.}

\item{plot.columns}{number of columns of the output plot if the inputs are lists. If not provided, it is computed automatically by \code{\link[grDevices]{n2mfrow}}.}

\item{plot.rows}{number of rows of the output plot if the inputs are lists. If not provided, it is computed automatically by \code{\link[grDevices]{n2mfrow}}.}

\item{legend}{boolean. If \code{TRUE}, the plot is made with \code{\link[fields]{image.plot}}, and includes a color scale on the right side. If \code{FALSE}, the plot is made with \code{\link[graphics]{image}}, and the color scale is omitted.}

\item{color.palette}{string defining the color palette to be used, or a color palette. Accepted strings are "divergent" (default), which uses a red-white-blue divergent palette produced by the code \code{colorRampPalette(rev(RColorBrewer::brewer.pal(9, "RdBu")))(100)}, and "viridis", which uses the default settings of the \code{\link[viridis]{viridis}} function to generate the palette. Both settings are color-blind friendly.}

\item{path.color}{string, color of the line representing the least cost path if \code{least.cost.path} is provided.}

\item{path.width}{line width (lwd) of the plotted path.}

\item{margins}{a numeric vector with four positions indicating the margins of each plotted matrix. Order of margins in this vector is: bottom, left, top, right.}

\item{pdf.filename}{character string with the name, without extension, of the pdf to be written. If \code{NULL}, no pdf is written.}

\item{pdf.width}{with in inches of the output pdf. Default value is 7.}

\item{pdf.height}{height in inches of the output pdf. Default value is 4.}

\item{pdf.pointsize}{base font size of the output pdf.}

\item{rotate}{boolean, if \code{TRUE}, the matrix is rotated. Allows the user to plot the matrix axes in the desired direction.}
}
\value{
A list of dataframes if \code{least.cost.matrix} is a list, or a dataframe if \code{least.cost.matrix} is a matrix. The dataframe/s have the following columns:
\itemize{
\item \emph{A} row/sample of one of the sequences.
\item \emph{B} row/sample of one the other sequence.
\item \emph{distance} distance between both samples, extracted from \code{distance.matrix}.
\item \emph{cumulative.distance} cumulative distance at the samples \code{A} and \code{B}.
}
}
\description{
Plots the output matrices of \code{\link{distanceMatrix}} and \code{\link{leastCostMatrix}}, and superimposes the least cost path generated by \code{\link{leastCostPath}}. This functions relies on \code{\link[fields]{image.plot}} to plot a color scale along with the matrix plot, or \code{\link[graphics]{image}} when a color scale is not needed.
}
\examples{

\donttest{
#loading data
data(sequenceA)
data(sequenceB)

#preparing datasets
AB.sequences <- prepareSequences(
 sequence.A = sequenceA,
 sequence.A.name = "A",
 sequence.B = sequenceB,
 sequence.B.name = "B",
 merge.mode = "complete",
 if.empty.cases = "zero",
 transformation = "hellinger"
 )

#computing distance matrix
AB.distance.matrix <- distanceMatrix(
 sequences = AB.sequences,
 grouping.column = "id",
 method = "manhattan",
 parallel.execution = FALSE
 )

#plot
plotMatrix(distance.matrix = AB.distance.matrix)

#viridis palette
plotMatrix(distance.matrix = AB.distance.matrix,
 color.palette = "viridis")

#custom palette
plotMatrix(distance.matrix = AB.distance.matrix,
color.palette = viridis::viridis(8, option = "B", direction = -1))

}

}
