% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphicalPlot.R
\name{graphicalPlot}
\alias{graphicalPlot}
\title{Plot Graphs}
\usage{
graphicalPlot(ginp, graph_selection_input = 0, curvedEdgeLines = TRUE)
}
\arguments{
\item{ginp}{The prepared graph object from prepareGraphs function}

\item{graph_selection_input}{The type of graphical projection to be used. Default projection is 0 (Fruchterman Reingold). Selection must be a numeric option from 0-3. Other options include:
1 = Kamada Kawai,
2 = Reingold Tilford, and
3 = Bipartite}

\item{curvedEdgeLines}{Whether the edges between nodes should be curved or straight. Default is curved lines.}
}
\value{
Returns graphical plot to disk, if selected, or to R console
}
\description{
Plots the graph using the base plot function. To map attributes on the graph use the plotGraphs functions, 1 attribute with `plotGraphs` or 2 attributes with `plotGraphs2`.
}
\examples{

df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1",
directedNet = TRUE, selfInteract = FALSE, weightedGraph = TRUE)

#Plot the graph
graphicalPlot(baseNet)


}
