% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badges.R
\name{badges}
\alias{badges}
\alias{badges_user}
\alias{badge_create}
\title{Work with badges}
\usage{
badges(url = NULL, key = NULL, user = NULL, ...)

badges_user(username, url = NULL, key = NULL, user = NULL, ...)

badge_create(name, badge_type_id, description = NULL, allow_title = NULL,
  multiple_grant = NULL, icon = NULL, listable = NULL,
  target_posts = NULL, enabled = NULL, auto_revoke = NULL,
  badge_grouping_id = NULL, show_posts = NULL, image = NULL,
  long_description = NULL, url = NULL, key = NULL, user = NULL, ...)
}
\arguments{
\item{url}{Base url for a Discourse installation. See 
\code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{username}{A current user name. required}

\item{name}{(character) A badge name to be created. required}

\item{badge_type_id}{(integer) A badge type id. one of 1 (gold), 2 (silver),
or 3 (bronze). required}

\item{description}{(character) A description(character) . optional}

\item{allow_title}{(logical) Allow a title. optional}

\item{multiple_grant}{(character) multiple grant. optional}

\item{icon}{(character) icon. optional}

\item{listable}{(logical) listable. optional}

\item{target_posts}{(character) . optional}

\item{enabled}{(logical) enabled or not. optional}

\item{auto_revoke}{(character) auto revoke. optional}

\item{badge_grouping_id}{(character) badge grouping id. optional}

\item{show_posts}{(logical) show posts. optional}

\item{image}{(character) an image. optional}

\item{long_description}{(character) long description. optional}
}
\description{
Work with badges
}
\examples{
\dontrun{
# all badges
badges()

# specific badge by name
badges_user("sckott")

# create a badge
(res <- badge_create(name = "funnestbadge", badge_type_id = 3))
}
}
