# twoStepsBenchmark works

    Code
      twoStepsBenchmark(mensualts, trimts, include.differenciation = TRUE)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       13.9409   -0.2365  
      
                    Jan          Feb          Mar          Apr          May
      2010                                        -13.22506554 -11.71372098
      2011  -1.19387013   0.08590658   1.10796354   2.61006491   4.17807049
      2012  15.45056091  16.54021287  17.50542088  18.65068625  19.76940010
                    Jun          Jul          Aug          Sep          Oct
      2010 -10.72873730  -9.11931306  -7.82345954  -6.91584498  -5.46078545
      2011   5.52777964   7.09374325   8.43906493   9.89280103  11.72185029
      2012  21.15126679  22.12815363  23.08607327  24.55394736  26.06811624
                    Nov          Dec
      2010  -4.03665203  -2.57391349
      2011  12.97733182  14.35112611
      2012                          

---

    Code
      bn
    Output
      
      Call:
      twoStepsBenchmark(hfserie = mensualts, lfserie = trimts, include.differenciation = TRUE)
      
      Coefficients:
      constant   hfserie  
       14.9712   -0.2195  
      
                  Jan        Feb        Mar        Apr        May        Jun
      2010                       -15.335290 -13.894557 -12.642315 -10.972712
      2011  -1.381719  -0.042100   1.423819   2.823091   4.287695   5.709639
      2012  15.720840  16.958585  18.323328  19.604758  20.855109  22.183005
                  Jul        Aug        Sep        Oct        Nov        Dec
      2010  -9.679282  -8.333996  -6.979398  -5.597955  -4.016959  -2.757334
      2011   7.212468   8.360927   9.837019  11.270042  12.530967  14.038771
      2012  24.077039  25.305380  26.645391                                 

---

    Code
      twoStepsBenchmark(turnover, construction, include.differenciation = TRUE,
        include.rho = TRUE)
    Output
      
      Call:
      twoStepsBenchmark(hfserie = turnover, lfserie = construction, 
          include.differenciation = TRUE, include.rho = TRUE)
      
      Coefficients:
      constant   hfserie  
       -1.4628    0.1658  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2000 11.18206 11.04866 11.30853 11.38104 11.47692 11.49751 11.71882 11.65895
      2001 11.88900 12.04226 11.99001 11.92215 11.97729 11.95709 11.75578 12.11881
      2002 12.04639 11.99580 12.01635 12.33792 12.28315 12.23914 12.22651 12.40591
      2003 12.54442 12.73336 12.74881 12.77787 12.61749 12.92968 12.98524 13.24092
      2004 13.73072 13.75242 13.74804 14.00732 13.99253 14.02142 14.17507 13.98141
      2005 14.53184 14.59302 14.68313 14.83277 14.82667 14.93288 15.24826 15.34354
      2006 15.76601 15.94048 16.15560 16.15741 16.49926 16.67063 16.80853 16.74555
      2007 17.61591 17.78962 17.87036 17.75800 18.19025 18.16830 18.12346 18.12180
      2008 18.92701 19.03107 19.44082 19.04166 18.81393 19.06980 19.01261 19.10107
      2009 18.04609 17.97183 17.87240 17.86220 17.60670 17.61955 17.66419 17.47036
      2010 17.32424 17.03802 17.01274 17.08199 17.31522 17.48523 17.60756 17.52103
      2011 18.05156 18.08096 18.22196 18.27127 18.42152 18.27492 18.73944 18.25089
      2012 18.45104 18.18650 18.48644 18.42650 18.50758 18.32755 18.63630 18.30627
      2013 18.34021 18.07861 17.67714 18.32797 18.30978 18.17398 18.44345 18.53542
      2014 17.93146 18.28780 18.24397 18.12033 17.83074 18.34096 17.89400 18.43781
      2015 17.52809 17.47668 17.45319 17.37109 17.03633 17.45859 17.36123 17.26776
      2016 17.26094 17.55480 17.24287 17.14100 17.54099 17.15198 17.19781 17.22610
      2017 17.76803 17.97787 18.42889 17.63150 18.75671 19.02973 18.59849 18.33591
      2018 19.12903 19.17248 18.49080 19.25619 18.71611 19.39149 18.99632 19.58997
      2019 19.86381 20.12433 20.58937 20.58685 20.56888 20.04475 20.06336 21.21048
      2020 20.51222 19.71799 18.75753 16.25575 14.92516                           
                Sep      Oct      Nov      Dec
      2000 11.70021 11.73678 11.73296 11.95756
      2001 11.81373 12.15460 12.09583 12.18346
      2002 12.43690 12.55239 12.32945 12.43011
      2003 13.17545 13.33334 13.34199 13.47142
      2004 14.33490 14.45943 14.52438 14.57234
      2005 15.49567 15.48353 15.85800 15.57070
      2006 16.94003 16.87594 17.13380 17.50677
      2007 18.22127 18.35260 18.06905 18.41939
      2008 18.88760 18.93812 18.33361 18.40270
      2009 17.30808 17.41285 17.34143 17.62433
      2010 17.87258 17.76338 18.12096 17.95703
      2011 18.35222 18.31471 18.75703 18.76352
      2012 18.18506 18.33356 18.02702 18.02619
      2013 18.35993 18.25882 18.66823 18.92647
      2014 17.98088 17.88134 17.57529 17.77542
      2015 17.25076 17.38444 17.56184 17.34999
      2016 17.67069 17.54678 17.83421 17.63182
      2017 18.54037 18.55957 18.72319 19.24975
      2018 19.27087 19.82568 19.59630 19.86477
      2019 20.62628 20.47542 20.52958 20.41689
      2020                                    

# mts works

    Code
      bn
    Output
      
      Call:
      twoStepsBenchmark(hfserie = ts(matrix(rnorm(900, 0, 100), ncol = 3), 
          start = c(2000, 1), freq = 12) %>% `colnames<-`(c("a", "b", 
          "c")), lfserie = construction)
      
      Coefficients:
       constant          a          b          c  
      195.92267   -0.04149    0.04151   -0.03095  
      
                  Jan        Feb        Mar        Apr        May        Jun
      2000  8.9191558 12.9306806  8.8982857 15.5713986 12.4967904 23.0869095
      2001 15.2869162 12.2073564 27.8983736  8.0689454 13.7003714 16.0877242
      2002 29.7242356 10.3384906 13.0225735 21.3499582 12.4604077  8.4856501
      2003  9.2314051  8.1952616  8.8071680 20.0895829 21.3544841  6.0227980
      2004  6.6303480 10.7262339 24.4171028 16.7715225 13.1558522 17.6765666
      2005 13.5783468  1.4121441 14.0240082 13.4652621 23.5198453  2.1607070
      2006 14.5522945 14.3710855 22.8532183 17.0330312 18.8009321 15.2492176
      2007 16.6789993 19.7514089 18.5696153 26.4853791 18.2192406  6.5755761
      2008 17.8885518 18.2244005 15.1572600 18.1028252 20.3657769 15.6009484
      2009  4.0682301  6.5681735 18.2887625 18.5962724 28.9742321 24.0960443
      2010 21.2764277 19.8412229 18.5319926 12.6481714 28.7500145 16.2671813
      2011 17.5159537 16.6008294 15.4379095 19.6418785 29.7723430  8.0066752
      2012 20.6359562 11.2409785 12.4485180 29.0450297 27.8560498 24.6754915
      2013 10.5717984 19.6842910 15.3909812  8.2383169 22.3224000 16.3073964
      2014 14.1026599  7.7772796 21.0298217 17.2646142 28.1581418 19.9823536
      2015 19.1755787 20.3459446 12.0443190 22.7866604  7.0739878 13.7777647
      2016 18.9567217 11.2893188 15.1248433  7.1197011 17.8324875 21.0813804
      2017 19.1102830 24.9788467 15.1063347  8.5716745 11.5628993 26.6716657
      2018 25.6504750 14.6280603 21.7840078 25.8935466 21.4854104 16.0306614
      2019 18.1000882 17.8531041 16.5083238 17.6731359 18.6768366 28.2574678
      2020 19.9301452 23.4059260 20.7984037  7.2617049 14.5336352 23.9071501
      2021 15.6001245  8.0087784 18.2337688  5.1723630 18.8949263 13.3511340
      2022 13.4049049 16.2957307 13.2208742 14.6112655 22.3219438 25.1938067
      2023 21.4655444 13.1181520 17.9597036  8.1935700 21.0256590 27.2334741
      2024 12.4271361 10.7531829 13.3334222 12.8642849 22.8532867  8.9541535
                  Jul        Aug        Sep        Oct        Nov        Dec
      2000  9.6323827 14.6191697  9.1797676  2.0401035 12.0717884  8.9535676
      2001  7.6709583 23.4964492  2.4403646 -0.7203035 -2.8681323 20.6309763
      2002 15.1285272  2.6047617  1.9850059  8.3257012 19.6153699  4.2593184
      2003 18.4605343 16.5263728 10.4235894 16.7574758 14.1956534  5.8356746
      2004 14.1493983 16.0598124 15.5978810 17.5518442  9.3943619  7.1690761
      2005 15.5528173 25.8700971 16.5580791 13.9583146 20.2058098 21.0945687
      2006 13.5388954  8.6861116 23.4986898 15.2154778 16.5008053 18.9002409
      2007  6.7398348 23.3637176 28.2014401 14.8522784 11.6104825 25.6520272
      2008 20.0589578 17.0377865 17.7701217 15.7725657 16.4577548 34.5630507
      2009 24.5711608 19.7456630 29.5188232 13.0260610  6.0398228 18.3067543
      2010 23.0370056 17.1961346  7.6749669 13.8713562  9.5712995 21.4342267
      2011  7.4779026 25.9537902 20.2374393 17.9815345 19.6467690 22.2269751
      2012 16.7548441 24.0304694 14.5128719 14.5548381 10.7431801 13.4017726
      2013 27.7700593 25.9731014 17.8305032 23.1996458 29.8782385  2.9332679
      2014  5.9469177 24.5597764 24.0196505 15.3897190 19.4164653 18.6526002
      2015 15.3252074 20.5807804 22.5837298 22.1012533 15.5899559 17.1148181
      2016 12.9926464 19.6655634 26.5917290 27.1867839 13.2451434 17.9136812
      2017 10.9062095 27.5308209 23.7964211 15.8612417 18.3514357 19.1521672
      2018 28.0410408 15.6195893  9.6256232 18.9953010 34.0821481 -0.5358640
      2019 12.1728159 22.3718589 23.4784211 27.1089091 15.4171608 27.4818778
      2020 16.7180472 14.8700940  4.7701515 15.2378236 20.1625497 25.4526443
      2021 19.4439714  6.6494441 27.3058110 17.8276071 19.0864253 20.7508808
      2022 16.5566692 13.6967987  7.3334929 24.4146842 19.2607141 13.8316095
      2023 23.2356175 20.6970876 32.0529193 19.9211867 18.2516009 34.4468806
      2024 17.1529147  6.3620464 17.4421166 17.3337470 14.2662787 19.7290736

# reUseBenchmark works

    Code
      benchmark2
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
                  Jan        Feb        Mar        Apr        May        Jun
      2006  -65.50127 -159.34279  -85.60572  -59.90756  -83.27853  174.84116
      2007  -75.01805 -181.78026  -96.89683  -67.47877  -94.04491  193.73851
      2008  -82.76140 -199.03778 -108.49065  -74.56942  -99.58106  207.46798
      2009  -81.02708 -192.67153 -102.13600  -72.01255  -95.84200  195.63952
      2010  -78.71041 -183.47465  -97.35487  -68.74330  -94.10984  193.69849
      2011  -82.04061 -195.47606 -105.00809  -74.21605 -101.12248  203.92775
      2012  -85.86644 -200.91665 -109.27099  -76.94056 -104.30113  208.72910
      2013  -86.71574 -202.13322 -105.24245  -77.14943 -103.68452  207.42831
      2014  -83.62274 -202.22319 -107.42178  -75.11357  -99.42247  207.47409
      2015  -82.64277 -195.65218 -104.51441  -73.54135  -97.12040  200.98171
      2016  -82.08553 -197.48508 -103.31458  -72.38109  -99.82659  196.52951
      2017  -85.09090 -204.00603 -112.00924  -75.58591 -108.62130  221.35310
      2018  -92.55989 -218.99613 -112.66087  -83.07130 -108.45526  225.87125
      2019  -97.78936 -234.14393 -128.58171  -91.16780 -122.52688  238.28541
      2020 -102.96985 -232.95676 -118.66725  -72.64020  -89.54134           
                  Jul        Aug        Sep        Oct        Nov        Dec
      2006 -579.88576   62.47659 -137.97688  128.70734   91.59574   48.26871
      2007 -636.78872   68.52188 -151.61676  142.50565   97.94971   51.32165
      2008 -684.50055   73.55628 -161.63609  150.41841  101.57907   52.20761
      2009 -650.30495   68.23844 -151.00245  140.09146   97.17405   50.27068
      2010 -645.77489   68.25789 -155.52163  142.53953  101.50806   51.22581
      2011 -695.27686   71.65995 -161.82062  148.73378  106.40444   54.12234
      2012 -706.70721   73.04655 -163.98061  151.44947  103.59201   52.48577
      2013 -699.55892   73.92930 -165.13121  150.18681  106.85283   54.86937
      2014 -671.23138   73.14222 -160.66385  146.71101  100.48637   51.64092
      2015 -665.19618   69.45945 -157.26872  144.75979  101.68479   50.76700
      2016 -655.26332   69.03819 -160.55223  145.78504  103.22533   51.66367
      2017 -720.59482   74.31508 -171.11689  156.00143  109.38590   56.75492
      2018 -737.55455   79.61132 -178.83386  167.66910  115.30130   58.97067
      2019 -798.00226   87.64738 -196.35178  176.45992  122.86963   61.40337
      2020                                                                  

---

    Code
      benchmark3
    Output
      
      Call:
      reUseBenchmark(hfserie = adjusted_turnover, benchmark = benchmark1, 
          reeval.smoothed.part = TRUE)
      
      Coefficients:
      constant   hfserie    LS2009  
      -0.86421   0.16072  -0.03049  
      
                    Jan          Feb          Mar          Apr          May
      2006    4.9262753  -88.8574148  -14.9904259   10.9097677  -12.1870797
      2007    0.8619627 -105.0508499  -19.3195361   10.9448962  -14.7763929
      2008    3.2113195 -112.3522169  -21.2121272   13.1821997  -11.4762215
      2009    5.5879589 -106.6413565  -16.6697684   12.9106667  -11.4408875
      2010    2.2671537 -102.7530555  -16.7905114   11.7625770  -13.5637122
      2011    2.3822468 -110.2833454  -19.1058499   12.3353907  -13.9821622
      2012    3.8129991 -111.1470085  -19.4271614   12.9614181  -14.3570302
      2013    2.9883027 -112.5303826  -15.7559067   12.2057230  -14.4758367
      2014    3.8707906 -114.9819868  -20.4180164   11.6676486  -12.8489122
      2015    2.8055130 -110.3020691  -19.2720817   11.5835635  -12.1225271
      2016    1.5496305 -113.9717323  -19.8408473   11.1352263  -16.1854727
      2017    2.5078564 -115.7018157  -23.0765309   13.8983451  -18.6624623
      2018   -1.5748132 -128.0350014  -21.6065604    8.1933109  -16.8632119
      2019    0.6386821 -134.5828835  -28.0191044   10.2649327  -20.3554647
      2020    0.3792289 -129.8944349  -15.8656190   29.9268108   12.8171204
                    Jun          Jul          Aug          Sep          Oct
      2006  246.2788349 -508.0297596  134.8230114  -65.0679424  202.2509017
      2007  273.8503601 -555.8350568  150.3158402  -68.9840133  225.9756617
      2008  295.8061562 -596.0489103  162.0015097  -73.3171516  238.4911870
      2009  279.5394609 -566.8852560  151.1988027  -68.4804880  222.1959362
      2010  274.3836111 -564.8520366  149.5172290  -73.8270699  224.7680503
      2011  291.5966024 -607.1397938  160.2049011  -72.9281124  237.9135113
      2012  298.6992951 -616.7269493  163.0208418  -74.0283058  241.3637451
      2013  296.4754189 -610.6884712  162.6079886  -76.6593669  238.4367080
      2014  293.8548706 -585.0284764  159.1821328  -74.7720401  232.4696005
      2015  285.8429255 -580.4812534  154.0184787  -72.8752237  228.9781362
      2016  280.3776216 -571.1260149  153.5468947  -75.5899225  231.2831557
      2017  311.7095673 -629.9176768  165.2359385  -80.0292739  247.1788388
      2018  317.9078606 -644.9562617  172.8884250  -84.7608221  262.6552060
      2019  341.0640734 -694.7477952  191.2462157  -92.5400217  280.3531657
      2020                                                                 
                    Nov          Dec
      2006  165.8460253  123.2978063
      2007  182.2554806  136.4616474
      2008  189.2858125  139.4284429
      2009  178.8819673  131.6029637
      2010  184.3692826  134.8184820
      2011  195.8110739  143.6955374
      2012  193.4522417  142.2759143
      2013  194.8657047  142.6301181
      2014  186.1266388  137.1777499
      2015  185.7183585  134.6061796
      2016  189.3414567  138.4800042
      2017  200.5761520  147.8810616
      2018  211.3175912  156.1342771
      2019  226.7129254  165.0652746
      2020                          

# annualBenchmark

    Code
      annualBenchmark(turnover, construction, end.coeff.calc = 2018)
    Output
      
      Call:
      annualBenchmark(hfserie = turnover, lfserie = construction, end.coeff.calc = 2018)
      
      Coefficients:
      constant   hfserie  
       41.6754    0.1437  
      
                Jan      Feb      Mar      Apr      May      Jun      Jul      Aug
      2000 11.18790 11.08078 11.31418 11.38489 11.47555 11.50064 11.69937 11.65411
      2001 11.88193 12.01952 11.97872 11.92408 11.97574 11.96180 11.79062 12.10821
      2002 12.05586 12.01403 12.03441 12.31620 12.27237 12.23841 12.23219 12.39292
      2003 12.54736 12.71961 12.74204 12.77681 12.64795 12.92918 12.98854 13.22188
      2004 13.71327 13.74605 13.75573 13.99343 13.99310 14.03014 14.17481 14.01798
      2005 14.54266 14.60508 14.69341 14.83418 14.84083 14.94564 15.23258 15.32963
      2006 15.78078 15.95041 16.15501 16.17447 16.48836 16.65423 16.79083 16.75307
      2007 17.58744 17.75357 17.83921 17.75761 18.14808 18.14503 18.12223 18.13697
      2008 18.91708 19.02044 19.38523 19.04550 18.85084 19.07183 19.01801 19.08694
      2009 18.08170 17.99428 17.88715 17.85944 17.62123 17.61768 17.64379 17.46531
      2010 17.31764 17.07088 17.05157 17.11551 17.32286 17.47674 17.59060 17.52477
      2011 18.05003 18.08948 18.22389 18.27708 18.41600 18.29590 18.70367 18.28371
      2012 18.44809 18.21415 18.47006 18.41473 18.48226 18.32415 18.59029 18.30348
      2013 18.33864 18.11388 17.76740 18.33242 18.31714 18.19944 18.43248 18.51120
      2014 17.97551 18.28037 18.23788 18.12570 17.86916 18.30525 17.91126 18.37539
      2015 17.54318 17.48958 17.46096 17.38231 17.08547 17.44549 17.35595 17.27056
      2016 17.25440 17.50984 17.24153 17.15653 17.50772 17.17640 17.22318 17.25602
      2017 17.78621 17.98246 18.38750 17.71038 18.69925 18.94935 18.58887 18.37433
      2018 19.12339 19.17124 18.58896 19.25910 18.79618 19.38493 19.04421 19.55876
      2019 19.77105 19.99741 20.40999 20.42633 20.43823 20.02044 20.08199 21.13052
      2020 20.93178 20.33328 19.58131 17.48417 16.39264       NA       NA       NA
      2021       NA       NA       NA       NA       NA       NA       NA       NA
                Sep      Oct      Nov      Dec
      2000 11.69617 11.73387 11.73625 11.93629
      2001 11.84649 12.14429 12.09544 12.17316
      2002 12.42558 12.53201 12.34568 12.44033
      2003 13.17743 13.32712 13.34799 13.47408
      2004 14.33485 14.45280 14.51862 14.56923
      2005 15.47679 15.48242 15.82396 15.59282
      2006 16.93817 16.89891 17.13840 17.47738
      2007 18.23943 18.36960 18.14032 18.46050
      2008 18.89071 18.91979 18.37771 18.41592
      2009 17.31628 17.40077 17.33467 17.57772
      2010 17.83992 17.75707 18.08006 17.95239
      2011 18.37322 18.34065 18.72217 18.72422
      2012 18.19828 18.32748 18.06297 18.06405
      2013 18.35764 18.26806 18.62042 18.84127
      2014 17.97170 17.87720 17.60321 17.76736
      2015 17.25222 17.36525 17.51695 17.33207
      2016 17.65091 17.55437 17.81557 17.65353
      2017 18.56432 18.59353 18.74767 19.21613
      2018 19.28058 19.75809 19.55429 19.78027
      2019 20.68757 20.62914 20.75737 20.74995
      2020       NA       NA       NA       NA
      2021       NA       NA       NA       NA

