% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npn.R
\name{npn}
\alias{npn}
\title{NPN - Non paranormal Transformation}
\usage{
npn(x, npn_func = "shrinkage", npn_thresh = NULL, verbose = TRUE)
}
\arguments{
\item{x}{The multivariate non-normal data to be transformed.}

\item{npn_func}{Optional parameter - The method of transformation to be applied. Can either be "shrinkage" or "truncation" but defaults to "shrinkage".}

\item{npn_thresh}{Optional parameter - The truncation threshold that is used when making use of truncation.}

\item{verbose}{Optional parameter - Prints additional output of the selected approach. Can either be "TRUE" or "FALSE" and defaults to "TRUE".}
}
\value{
Returns the transformed data matrix.
}
\description{
This functions allows us to transform non-normal multivariate data to that of
non paranormal data.
}
\examples{
data <- data_generator(n = 100, p = 50, seed = 123)
X <- data$X
X_transformed <- npn(X, npn_func = "truncation")
}
