% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\docType{class}
\name{MDS-class}
\alias{MDS-class}
\alias{MDS}
\title{Metric Dimensional Scaling}
\description{
An S4 Class implementing classical scaling (MDS).
}
\details{
MDS tries to maintain distances in high- and low-dimensional space,
it has the advantage over PCA that arbitrary distance functions can
be used, but it is computationally more demanding.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

MDS can take the following parameters:
\describe{
  \item{ndim}{The number of dimensions.}
  \item{d}{The function to calculate the distance matrix from the input coordinates, defaults to euclidean distances.}
}
}

\section{Implementation}{


Wraps around \code{\link[stats]{cmdscale}}. The implementation also
provides an out-of-sample extension which is not completely
optimized yet.
}

\examples{
\dontrun{
dat <- loadDataSet("3D S Curve")
emb <- embed(dat, "MDS")
plot(emb, type = "2vars")

# a "manual" kPCA:
emb2 <- embed(dat, "MDS", d = function(x) exp(stats::dist(x)))
plot(emb2, type = "2vars")

# a "manual", more customizable, and slower Isomap:
emb3 <- embed(dat, "MDS", d = function(x) vegan::isomapdist(vegan::vegdist(x, "manhattan"), k = 20))
plot(emb3)

}
}
\references{
Torgerson, W.S., 1952. Multidimensional scaling: I. Theory and method.
Psychometrika 17, 401-419. https://doi.org/10.1007/BF02288916
}
\seealso{
Other dimensionality reduction methods: 
\code{\link{AutoEncoder-class}},
\code{\link{DRR-class}},
\code{\link{DiffusionMaps-class}},
\code{\link{DrL-class}},
\code{\link{FastICA-class}},
\code{\link{FruchtermanReingold-class}},
\code{\link{HLLE-class}},
\code{\link{Isomap-class}},
\code{\link{KamadaKawai-class}},
\code{\link{NNMF-class}},
\code{\link{PCA-class}},
\code{\link{PCA_L1-class}},
\code{\link{UMAP-class}},
\code{\link{dimRedMethod-class}},
\code{\link{dimRedMethodList}()},
\code{\link{kPCA-class}},
\code{\link{nMDS-class}},
\code{\link{tSNE-class}}
}
\concept{dimensionality reduction methods}
