% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_align.R
\name{diff_align}
\alias{diff_align}
\title{algining texts}
\usage{
diff_align(text1 = NULL, text2 = NULL, tokenizer = NULL, ignore = NULL,
  clean = NULL, distance = c("lv", "osa", "dl", "hamming", "lcs", "qgram",
  "cosine", "jaccard", "jw", "soundex"), useBytes = FALSE, weight = c(d = 1,
  i = 1, s = 1, t = 1), maxDist = 0, q = 1, p = 0,
  nthread = getOption("sd_num_thread"), verbose = TRUE, ...)
}
\arguments{
\item{text1}{first text}

\item{text2}{second text}

\item{tokenizer}{defaults to NULL which will trigger linewise tokenization;
accepts a function that turns a text into a token data frame;
a token data frame has at least three columns:
from (first character of token),
to (last character of token)
token (the token)}

\item{ignore}{defaults to NULL which means that nothing is ignored;
function that accepts a token data frame (see above) and returns a
possibly subseted data frame of hte same form}

\item{clean}{defaults to NULL which means that nothing cleaned; accepts a
function that takes a vector of tokens and returns a vector of same
length - potentially clean up}

\item{distance}{defaults to Levenshtein ("lv"); see \link[stringdist]{amatch},
\link[stringdist]{stringdist-metrics}, \link[stringdist]{stringdist}}

\item{useBytes}{Perform byte-wise comparison, see
\code{\link{stringdist-encoding}}.}

\item{weight}{For \code{method='osa'} or \code{'dl'}, the penalty for
deletion, insertion, substitution and transposition, in that order. When
\code{method='lv'}, the penalty for transposition is ignored. When
\code{method='jw'}, the weights associated with characters of \code{a},
characters from \code{b} and the transposition weight, in that order. 
Weights must be positive and not exceed 1. \code{weight} is ignored
completely when \code{method='hamming'}, \code{'qgram'}, \code{'cosine'},
\code{'Jaccard'}, \code{'lcs'}, or \code{soundex}.}

\item{maxDist}{[DEPRECATED AND WILL BE REMOVED|2016] Currently kept for
backward compatibility. It does not offer any speed gain. (In fact, it
currently slows things down when set to anything different from
\code{Inf}).}

\item{q}{Size of the \eqn{q}-gram; must be nonnegative. Only applies to
\code{method='qgram'}, \code{'jaccard'} or \code{'cosine'}.}

\item{p}{Penalty factor for Jaro-Winkler distance. The valid range for 
\code{p} is \code{0 <= p <= 0.25}. If \code{p=0} (default), the
Jaro-distance is returned. Applies only to \code{method='jw'}.}

\item{nthread}{Maximum number of threads to use. By default, a sensible
number of threads is chosen, see \code{\link{stringdist-parallelization}}.}

\item{verbose}{should function report on its doings via messages or not}

\item{...}{further arguments passed through to distance function}
}
\value{
dataframe with tokens aligned according to distance
}
\description{
Function aligns two texts side by side as a data.frame with change type and
distance given as well
}

