% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLR.R
\name{MLR}
\alias{MLR}
\title{DDF likelihood ratio statistics based on multinomial log-linear regression model.}
\usage{
MLR(Data, group, key, type = "both", match = "zscore", anchor = 1:ncol(Data),
    p.adjust.method = "none", parametrization = "irt", alpha = 0.05)
}
\arguments{
\item{Data}{data.frame or matrix: dataset which rows represent unscored examinee answers (nominal)
and columns correspond to the items.}

\item{group}{numeric: binary vector of group membership. \code{"0"} for reference group, \code{"1"} for
focal group.}

\item{key}{character: the answer key. Each element corresponds to the correct answer of one item.}

\item{type}{character: type of DDF to be tested. Either \code{"both"} for uniform and non-uniform
DDF (i.e., difference in parameters \code{"a"} and \code{"b"}) (default), or \code{"udif"} for
uniform DDF only (i.e., difference in difficulty parameter \code{"b"}), or \code{"nudif"} for
non-uniform DDF only (i.e., difference in discrimination parameter \code{"a"}). Can be specified
as a single value (for all items) or as an item-specific vector.}

\item{match}{numeric or character: matching criterion to be used as an estimate of trait. Can be
either \code{"zscore"} (default, standardized total score), \code{"score"} (total test score),
or vector of the same length as number of observations in \code{Data}.}

\item{anchor}{character or numeric: specification of DIF free items. A vector of item identifiers
(integers specifying the column  number) specifying which items are currently considered as anchor
(DIF free) items. Argument is ignored if \code{match} is not \code{"zscore"} or \code{"score"}.}

\item{p.adjust.method}{character: method for multiple comparison correction. Possible values are
\code{"holm"}, \code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"},
\code{"fdr"}, and \code{"none"} (default). For more details see \code{\link[stats]{p.adjust}}.}

\item{parametrization}{character: parametrization of regression coefficients. Possible options are
\code{"irt"} for difficulty-discrimination parametrization (default) and \code{"classic"} for
intercept-slope parametrization. See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}
}
\value{
A list with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{par.m0}}{the estimates of null model.}
  \item{\code{par.m1}}{the estimates of alternative model.}
  \item{\code{se.m0}}{standard errors of parameters in null model.}
  \item{\code{se.m1}}{standard errors of parameters in alternative model.}
  \item{\code{ll.m0}}{log-likelihood of m0 model.}
  \item{\code{ll.m1}}{log-likelihood of m1 model.}
  \item{\code{AIC.m0}}{AIC of m0 model.}
  \item{\code{AIC.m1}}{AIC of m1 model.}
  \item{\code{BIC.m0}}{BIC of m0 model.}
  \item{\code{BIC.m1}}{BIC of m1 model.}
  }
}
\description{
Calculates DDF likelihood ratio statistics for nominal data based on
multinomial log-linear model.
}
\details{
Calculates DDF likelihood ratio statistics based on multinomial log-linear model. Probability of
selection the \eqn{k}-th category (distractor) is
\deqn{P(y = k) = exp((a_k + a_kDif*g)*(x - b_k - b_kDif*g)))/(1 + \sum exp((a_l + a_lDif*g)*(x - b_l - b_lDif*g))), }
where \eqn{x} is by default standardized total score (also called Z-score) and \eqn{g} is a group
membership. Parameters \eqn{a_k} and \eqn{b_k} are discrimination and difficulty for the \eqn{k}-th
category. Terms \eqn{a_kDif} and \eqn{b_kDif} then represent differences between two groups
(reference and focal) in relevant parameters. Probability of correct answer (specified in argument
\code{key}) is
\deqn{P(y = k) = 1/(1 + \sum exp((a_l + a_lDif*g)*(x - b_l - b_lDif*g))). }
Parameters are estimated via neural networks. For more details see \code{\link[nnet]{multinom}}.

Argument \code{parametrization} is a character which specifies parametrization of regression parameters.
Default option is \code{"irt"} which returns IRT parametrization (difficulty-discrimination, see above).
Option \code{"classic"} returns intercept-slope parametrization with effect of group membership and
interaction with matching criterion, i.e. \eqn{b_0k + b_1k*x + b_2k*g + b_3k*x*g} instead of
\eqn{(a_k + a_kDif*g)*(x - b_k - b_kDif*g))}.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMATtest, GMATkey)

Data <- GMATtest[, 1:20]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
MLR(Data, group, key, type = "both")

# Testing uniform DDF effects
MLR(Data, group, key, type = "udif")

# Testing non-uniform DDF effects
MLR(Data, group, key, type = "nudif")
}

}
\seealso{
\code{\link[stats]{p.adjust}} \code{\link[nnet]{multinom}}
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{DDF}
