% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MLR.R
\name{MLR}
\alias{MLR}
\title{DDF likelihood ratio statistics based on Multinomial Log-linear Regression model.}
\usage{
MLR(Data, group, key, type = "both", match = "zscore", anchor = 1:ncol(Data),
p.adjust.method = "none", alpha = 0.05)
}
\arguments{
\item{Data}{character: the unscored data matrix.}

\item{group}{numeric or character: the binary vector of group membership}

\item{key}{character: the answer key.}

\item{type}{character: type of DDF to be tested (either "both" (default), "udif", or "nudif").
See \strong{Details}.}

\item{match}{specifies matching criterion. Can be either \code{"zscore"} (default, standardized total score),
\code{"score"} (total test score), or vector of the same length as number of observations in \code{Data}. See \strong{Details}.}

\item{anchor}{a vector of integers specifying which items are currently considered as anchor (DIF free) items. By
default, all items are considered as anchors. Argument is ignored if \code{match} is not \code{"zscore"} or \code{"score"}.
See \strong{Details}.}

\item{p.adjust.method}{character: method for multiple comparison correction.
See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}
}
\value{
A list with the following arguments:
\describe{
  \item{\code{Sval}}{the values of likelihood ratio test statistics.}
  \item{\code{pval}}{the p-values by likelihood ratio test.}
  \item{\code{adj.pval}}{the adjusted p-values by likelihood ratio test using \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of likelihood ratio test.}
  \item{\code{par.m0}}{the estimates of null model.}
  \item{\code{par.m1}}{the estimates of alternative model.}
  \item{\code{cov.m0}}{the estimates of covariance structure of null model.}
  \item{\code{cov.m1}}{the estimates of covariance structure of alternative model.}
  \item{\code{ll.m0}}{log-likelihood of m0 model.}
  \item{\code{ll.m1}}{log-likelihood of m1 model.}
  \item{\code{AIC.m0}}{AIC of m0 model.}
  \item{\code{AIC.m1}}{AIC of m1 model.}
  \item{\code{BIC.m0}}{BIC of m0 model.}
  \item{\code{BIC.m1}}{BIC of m1 model.}
  }
}
\description{
Calculates DDF likelihood ratio statistics based on multinomial log-linear model.
}
\details{
Calculates DDF likelihood ratio statistics based on multinomial log-linear model.

The \code{Data} is a matrix whose rows represents examinee unscored answers and
columns correspond to the items. The \code{group} must be a vector of the same
length as \code{nrow(data)}. The \code{key} must be a vector of correct answers
corresponding to columns of \code{Data}.

The \code{type} corresponds to type of DDF to be tested. Possible values are \code{"both"}
to detect any DDF (uniform and/or non-uniform), \code{"udif"} to detect only uniform DDF or
\code{"nudif"} to detect only non-uniform DDF.

Argument \code{match} represents the matching criterion. It can be either the standardized test score (default, \code{"zscore"}),
total test score (\code{"score"}), or any other continuous or discrete variable of the same length as number of observations
in \code{Data}. Matching criterion is used in \code{NLR} function as a covariate in non-linear regression model.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the
\code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMATtest, GMATkey)

Data  <- GMATtest[, 1:20]
group <- GMATtest[, "group"]
key <- GMATkey

# Testing both DDF effects
MLR(Data, group, key, type = "both")

# Testing uniform DDF effects
MLR(Data, group, key, type = "udif")

# Testing non-uniform DDF effects
MLR(Data, group, key, type = "nudif")
}
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
\keyword{DDF}
