% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{dialr-match}
\alias{dialr-match}
\alias{is_match}
\title{Phone number equality checks}
\usage{
is_match(e1, e2, detailed = FALSE, strict = TRUE, not_number_na = TRUE)
}
\arguments{
\item{e1}{A \link{phone} or character vector.}

\item{e2}{A \link{phone} or character vector.}

\item{detailed}{If \code{FALSE}, \code{is_match()} returns a logical vector. If \code{TRUE},
it returns a character vector with the match type. See Details section for
possible return values.}

\item{strict}{If \code{TRUE}, only \code{"EXACT_MATCH"} is treated as a match. If
\code{FALSE}, \code{"EXACT_MATCH"}, \code{"NSN_MATCH"} and \code{"SHORT_NSN_MATCH"} are all
considered a match. Ignored if \code{detailed = TRUE}.}

\item{not_number_na}{If \code{TRUE}, \code{"NOT_A_NUMBER"} is converted to \code{NA}.}
}
\value{
A logical or character vector.
}
\description{
Check if two vectors contain matching phone numbers. See Details section for
a full list of match types. \code{is_match()} with default arguments is used to
implement \code{==} and \code{!=} for phone vectors.

\code{is_match()} accepts phone or atomic vectors. Atomic vectors are converted to
character for comparison. Note that although they can contain formatting
character vectors are not parsed with a default region, so they will only
ever be an \code{"EXACT_MATCH"} if a country calling code is specified with \code{+} at
the start. See Examples.
}
\details{
Possible return values for \code{is_match(x, detailed = TRUE)}:
\itemize{
\item \code{"EXACT_MATCH"}: The country_code, NSN, presence of a leading zero for
Italian numbers and any extension present are the same.
\item \code{"NSN_MATCH"}: Either or both values has no region specified, and the NSNs
and extensions are the same.
\item \code{"SHORT_NSN_MATCH"}: Either or both values has no region specified, or the
region specified is the same, and one NSN could be a shorter version of the
other number. This includes the case where one has an extension specified,
and the other does not.
\item \code{"NOT_A_NUMBER"}: One of the input phone numbers failed to parse.
\item \code{"NO_MATCH"}: All others.
}

For example, the numbers \verb{+1 345 657 1234} and \verb{657 1234} are a
\code{"SHORT_NSN_MATCH"}. The numbers \verb{+1 345 657 1234} and \verb{345 657} are a
\code{"NO_MATCH"}.
}
\section{libphonenumber reference}{


\code{is_match()}: \code{PhoneNumberUtil.isNumberMatch()}
}

\examples{
is_match(phone("0412 345 678", "AU"), phone("+61412345678", "AU"))

phone("0412 345 678", "AU") == phone("+61412345678", "AU")
phone("0412 345 678", "AU") != phone("+61412345678", "AU")

# character vectors are only fully specified with a country calling code
is_match("0412345678", "0412345678", detailed = TRUE)
is_match("+61412345678", "+61412345678", detailed = TRUE)

is_match(phone("0412345678", "AU"), "0412345678", detailed = TRUE)
is_match(phone("+61412345678", "AU"), "+61412345678", detailed = TRUE)
}
\seealso{
Other phone functions: 
\code{\link{dialr-example}},
\code{\link{dialr-phone}},
\code{\link{dialr-region}},
\code{\link{dialr-type}},
\code{\link{dialr-valid}},
\code{\link{dialr}}
}
\concept{phone functions}
