% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dialr.R
\docType{package}
\name{dialr-package}
\alias{dialr}
\alias{dialr-package}
\title{dialr: Parse, Format, and Validate International Phone Numbers}
\description{
\if{html}{\figure{logo.png}{options: align='right' alt='logo' width='120'}}

Parse, format, and validate international phone
    numbers using Google's 'libphonenumber' java library,
    <https://github.com/google/libphonenumber>.
}
\section{Options}{

\itemize{
\item \code{dialr.home}: The default \link[=dialr-region]{region} used to process phone
numbers where no region is provided. (default: \code{"AU"}).
\item \code{dialr.format}: The default format used to print clean phone numbers. See
\code{\link[=format.phone]{format.phone()}} for details. (default: \code{"E164"}).
\item \code{dialr.locale}: The default \href{https://docs.oracle.com/javase/8/docs/api/java/util/Locale.html}{Java locale} used
to retrieve localised results in \link[=get_geocode]{geographical} and
\link[=get_carrier]{carrier} information (default: \code{"en"}).
\item \code{dialr.show_progress}: Should lengthy operations such as \code{\link[=phone]{phone()}} show a
progress bar? (default: \code{TRUE}).
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://socialresearchcentre.github.io/dialr}
  \item \url{https://github.com/socialresearchcentre/dialr}
  \item \url{https://github.com/socialresearchcentre/dialrjars}
  \item \url{https://github.com/google/libphonenumber}
  \item Report bugs at \url{https://github.com/socialresearchcentre/dialr/issues}
}


Other phone functions: 
\code{\link{dialr-example}},
\code{\link{dialr-match}},
\code{\link{dialr-phone}},
\code{\link{dialr-region}},
\code{\link{dialr-type}},
\code{\link{dialr-valid}}
}
\author{
\strong{Maintainer}: Danny Smith \email{danny@gorcha.org}

Other contributors:
\itemize{
  \item The Social Research Centre [copyright holder]
}

}
\concept{phone functions}
\keyword{internal}
