% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_document_frequencies.R
\name{get_document_frequencies}
\alias{get_document_frequencies}
\title{Retrieve Token Frequencies in Documents}
\usage{
get_document_frequencies(pids, cutoff = 0, words = NULL)
}
\arguments{
\item{pids}{A vector or data frame containing document IDs.}

\item{cutoff}{A numeric value specifying the frequency cutoff for tokens.}

\item{words}{A vector of words (tokens) to retrieve frequencies for.}
}
\value{
A list containing the following elements for each document:
\itemize{
\item Document ID
\item Token
\item Token frequency in the document
\item Total tokens in the document
}
}
\description{
This function obtains token frequencies within specified documents.
}
\examples{
document_ids <- c("URN:NBN:no-nb_digibok_2008051404065", "URN:NBN:no-nb_digibok_2010092120011")
frequency_cutoff <- 10
tokens <- c(".", ",", "men")
result <- get_document_frequencies(document_ids, frequency_cutoff, tokens)
}
