% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlpb.R
\name{MLPB_boot}
\alias{MLPB_boot}
\title{Multivariate Linear Process Bootstrap Method}
\usage{
MLPB_boot(boot_options)
}
\arguments{
\item{boot_options}{a list of option being specify by \code{option_control} function.}
}
\description{
Multivariate Linear Process Bootstrap (MLPB) method to assess the uncertainty in dynamic functional connectivity (dFC) by providing its confidence band.
}
\details{
The \code{dataList} parameter is a list of matrices which contains time series data of each region of interest (ROI). Output directory is required here because the results to be generate is massive.
}
\examples{
\dontshow{
# Load sample data
data(fMRI_dataList_shrinked)
boot_option <- options_boot(input_list = fMRI_dataList, output_dir = tempdir(),
 rois = c(1,2), timepoints = 5, window_size = 5)
MLPB_boot(boot_option)
rm(list=c('fMRI_dataList_shrinked','boot_option'))
gc()
}
\donttest{

# Load sample data

data(fMRI_dataList)
boot_option <- options_boot(input_list = fMRI_dataList, output_dir = tempdir(),
 rois = c(1,2,3), timepoints = 5, window_size = 5)
MLPB_boot(boot_option)

}
}
\references{
Kudela et al. (2017) NeuroImage 10.1016/j.neuroimage.2017.01.056
(\href{https://www.ncbi.nlm.nih.gov/pubmed/28132931}{PubMed})
}
\keyword{bootstarpping}
