% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/deps.R
\name{package_deps}
\alias{dev_package_deps}
\alias{package_deps}
\alias{update.package_deps}
\title{Find all dependencies of a CRAN or dev package.}
\usage{
package_deps(pkg, dependencies = NA, repos = getOption("repos"),
  type = getOption("pkgType"))

dev_package_deps(pkg = ".", dependencies = NA, repos = getOption("repos"),
  type = getOption("pkgType"))

\method{update}{package_deps}(object, ..., quiet = FALSE, upgrade = TRUE)
}
\arguments{
\item{pkg}{A character vector of package names. If missing, defaults to
the name of the package in the current directory.}

\item{dependencies}{Which dependencies do you want to check?
  Can be a character vector (selecting from "Depends", "Imports",
   "LinkingTo", "Suggests", or "Enhances"), or a logical vector.

  \code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
  "Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
  and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
  just check this package, not its dependencies).}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.  If "both", will switch
automatically to "binary" to avoid interactive prompts during package
installation.}

\item{object,...}{Arguments ot}

\item{quiet}{If \code{TRUE}, suppress output}

\item{upgrade}{If \code{TRUE}, also upgrade any of out date dependencies.}
}
\value{
A data frame with additional.
}
\description{
Find all the dependencies of a package and determine whether they ahead
or behind cran. A \code{print()} method focusses on mismatches between local
and CRAN version; a \code{update()} method installs outdated or missing
packages from CRAN.
}
\examples{
\dontrun{
package_deps("devtools")
# Use update to update any updated/
update(package_deps("devtools"))
}
}

