% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/with-debug.r
\name{with_debug}
\alias{with_debug}
\title{Temporarily set debugging compilation flags.}
\usage{
with_debug(code, CFLAGS = NULL, CXXFLAGS = NULL, FFLAGS = NULL,
  FCFLAGS = NULL, debug = TRUE, action = "replace")
}
\arguments{
\item{code}{to execute.}

\item{CFLAGS}{flags for compiling C code}

\item{CXXFLAGS}{flags for compiling C++ code}

\item{FFLAGS}{flags for compiling Fortran code.}

\item{FCFLAGS}{flags for Fortran 9x code.}

\item{debug}{If \code{TRUE} adds \code{-g -O0} to all flags
(Adding \env{FFLAGS} and \env{FCFLAGS}}

\item{action}{(for \code{with_envvar} only): should new values
\code{"replace"}, \code{"suffix"}, \code{"prefix"} existing environmental
variables with the same name.}
}
\description{
Temporarily set debugging compilation flags.
}
\examples{
flags <- names(compiler_flags(TRUE))
with_debug(Sys.getenv(flags))

\dontrun{
install("mypkg")
with_debug(install("mypkg"))
}
}
\seealso{
Other debugging flags: \code{\link{compiler_flags}}
}

