% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bayoh_03}
\alias{bayoh_03}
\title{Bayoh and Lindsay equation of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1079/BER2003259}
}
\usage{
bayoh_03
}
\description{
Bayoh, M.N., Lindsay, S.W. (2003) Effect of temperature on the development of the aquatic
stages of Anopheles gambiae sensu stricto (Diptera: Culicidae). Bulletin of entomological
research 93(5): 375-81.
}
\details{
Equation:
rT ~ aa + bb * T + cc * exp(T) + dd * exp(-T)

where rT is the development rate, T the temperature, and aa, bb,
cc, and dd empirical constant parameters.
}
\keyword{datasets}

