% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_infinite_estimates.R
\name{check_infinite_estimates.glm}
\alias{check_infinite_estimates.glm}
\alias{checkInfiniteEstimates}
\title{A simple diagnostic of whether the maximum likelihood estimates are
infinite}
\usage{
\method{check_infinite_estimates}{glm}(object, nsteps = 20, ...)
}
\arguments{
\item{object}{the result of a \code{\link{glm}} call.}

\item{nsteps}{starting from \code{maxit = 1}, the GLM is refitted
for \code{maxit = 2}, \code{maxit = 3}, \ldots, \code{maxit =
nsteps}. Default value is 30.}

\item{...}{currently not used.}
}
\value{
An object of class \code{inf_check} that has a \code{plot} method.

A matrix inheriting from class \code{inf_check}, with \code{nsteps}
rows and \code{p} columns, where \code{p} is the number of model
parameters. A \code{plot} method is provided for \code{inf_check}
objects for the easy inspection of the ratios of the standard
errors.
}
\description{
A simple diagnostic of whether the maximum likelihood estimates are
infinite
}
\details{
\code{check_infinite_estimates} attempts to identify the occurence
of infinite estimates in GLMs with binomial responses by
successively refitting the model. At each iteration the maximum
number of allowed IWLS iterations is fixed starting from 1 to
\code{nsteps} (by setting \code{control = glm.control(maxit = j)},
where \code{j} takes values 1, \ldots, nsteps in
\code{\link{glm}}). For each value of \code{maxit}, the estimated
asymptotic standard errors are divided to the corresponding ones
from \code{control = glm.control(maxit = 1)}. Then, based on the
results in Lesaffre & Albert (1989), if the sequence of ratios in
any column of the resultant matrix diverges, then complete or
quasi-complete separation occurs and the maximum likelihood
estimate for the corresponding parameter has value minus or plus
infinity.
}
\note{
For the definition of complete and quasi-complete separation, see
Albert and Anderson (1984). Kosmidis and Firth (2019) prove that
the reduced-bias estimator that results by the penalization of the
logistic regression log-likelihood by Jeffreys prior takes always
finite values, even when some of the maximum likelihood estimates
are infinite. The reduced-bias estimates can be computed using the
\pkg{brglm2} R package.
}
\examples{

## endometrial data from Heinze \& Schemper (2002) (see ?endometrial)
data("endometrial", package = "detectseparation")
endometrial_ml <- glm(HG ~ NV + PI + EH, data = endometrial,
                      family = binomial("probit"))
## clearly the maximum likelihood estimate for the coefficient of
## NV is infinite
(estimates <- check_infinite_estimates(endometrial_ml))
plot(estimates)


\donttest{
## Aligator data (Agresti, 2002, Table~7.1)
if (requireNamespace("brglm2", quietly = TRUE)) {
    data("alligators", package = "brglm2")
    all_ml <- brglm2::brmultinom(foodchoice ~ size + lake , weights = round(freq/3),
                         data = alligators, type = "ML", ref = 1)
    ## Clearly some estimated standard errors diverge as the number of
    ## Fisher scoring iterations increases
    plot(check_infinite_estimates(all_ml))
    ## Bias reduction the brglm2 R packages can be used to get finite estimates
    all_br <- brglm2::brmultinom(foodchoice ~ size + lake , weights = round(freq/3),
                         data = alligators, ref = 1)
    plot(check_infinite_estimates(all_br))
}
}
}
\references{
Lesaffre, E., & Albert, A. (1989). Partial Separation in Logistic
Discrimination. *Journal of the Royal Statistical Society. Series B
(Methodological)*, **51**, 109-116

Kosmidis I. and Firth D. (2019). Jeffreys-prior penalty, finiteness
and shrinkage in binomial-response generalized linear
models. arXiv:1812.01938.
\url{https://arxiv.org/abs/1812.01938v3}
}
\seealso{
\code{\link[nnet]{multinom}},
    \code{\link{detect_separation}},
    \code{\link[brglm2]{brmultinom}}
}
