% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testMax.R
\name{testMax}
\alias{testMax}
\title{Max-type test for for the equality of connectivity}
\usage{
testMax(subY1, subY2, diagTF = TRUE, nboot, q = "andrew", n.cl)
}
\arguments{
\item{subY1}{a sample of size length*dim}

\item{subY2}{a sample of size length*dim}

\item{diagTF}{include diagonal term of covariance matrix or not}

\item{nboot}{number of bootstrap sample, default is 2000}

\item{q}{methods in calculating long-run variance of the test statistic. Defaul is "andrew". Second option "fixed" = length^{1/3} or user specify the length}

\item{n.cl}{number of cores in parallel computing. The default is (machine cores - 1)}
}
\value{
\strong{tstat} Test statisticlue for testing the equality of connectivity structure

\strong{pval} The pvalue for testing the equality of connectivity structure

\strong{q} The tuning parameter used in calulating long-run variance
}
\description{
This function produces three test results based on max-type block boostrap (BMB), long-run variance block boostrapping with lagged-window estimator (LVBWR) and sum-type block bootstrap (BSUM). See Baek el al. (2019) for details.
}
\examples{
\donttest{test2 = testMax(testsim$X, testsim$Y, n.cl=1)}
}
