## this checks the data if that looks as expected
checkDesign <- function(Y, D, X, Z, Q, count=TRUE) {
    if (length(Y) < 1)
        stop("empty model")
    if (all(Y > 0, na.rm=TRUE) && !is.null(Q))
        warning("dependent variable has no 0 value, zero-inflated model might not be adequate")
    if (!any(Y > 1, na.rm=TRUE) && count)
        warning("dependent variable does not contain any count > 1")
    if (!isTRUE(all.equal(as.vector(Y), as.integer(round(Y + 0.001)))))
        stop("invalid dependent variable, non-integer values")
    if (any(Y < 0, na.rm=TRUE)) 
        stop("invalid dependent variable, negative counts")
    multi <- if (is.null(D))
        0 else NCOL(D) > 1
    if (multi) {
        if (NCOL(D) > 1)
          for (i in 2:ncol(D))
              if (any(D[,i-1] >= D[,i], na.rm=TRUE))
                  stop("values in methodology matrix must increase by columns")
        yna <- is.na(Y)
        if (any(!((yna + is.na(D)) %in% c(0,2))))
            stop("NA pattern in response and methodology must match")
        if (any(rowSums(!yna) < 2))
            stop("at least 2 sub-interval is required for each row")
        if (NCOL(Y) > 1)
          for (i in 2:ncol(Y))
              if (any(yna[,i-1] > yna[,i]))
                  stop("all non NA values must be left to NAs")
        if (any(is.na(X)))
            stop("NA values found in abundance part")
        if (!is.null(Z))
            if (any(is.na(Z)))
                stop("NA values found in detection part")
        if (!is.null(Q))
            if (any(is.na(Q)))
                stop("NA values found in zero-inflation part")
    } else {
        if (ncol(X) < 2)
            stop("define abundance covariates")
        if (ncol(Z) < 2)
            stop("define detection covariates")
        ## check factors and unique values
        ## and setdiff of colnames
        ## for SV assumptions
        if (any(is.na(Y)))
            stop("NA values found in response vector")
        if (!is.null(D))
            if (any(is.na(D)))
                stop("NA values found in methodology vector")
        if (any(is.na(X)))
            stop("NA values found in abundance part")
        if (any(is.na(Z)))
            stop("NA values found in detection part")
        if (!is.null(Q))
            if (any(is.na(Q)))
                stop("NA values found in zero-inflation part")
    }
    invisible(TRUE)
}
