% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_geo_polar.R
\docType{data}
\name{coord_geo_polar}
\alias{coord_geo_polar}
\alias{CoordGeoPolar}
\title{Polar coordinate system with geological timescale}
\usage{
coord_geo_polar(
  dat = "periods",
  theta = "y",
  start = -pi/2,
  direction = -1,
  clip = "on",
  fill = NULL,
  alpha = 1,
  lwd = 0.25,
  color = "grey80",
  lty = "solid",
  lab = FALSE,
  abbrv = TRUE,
  skip = c("Quaternary", "Holocene", "Late Pleistocene"),
  neg = TRUE,
  prop = 1,
  textpath_args = list()
)
}
\arguments{
\item{dat}{Either A) a string indicating a built-in dataframe with interval
data from the ICS ("periods", "epochs", "stages", "eons", or "eras"), B) a
string indicating a timescale from macrostrat (see list here:
\url{https://macrostrat.org/api/defs/timescales?all}), or C) a custom
data.frame of time interval boundaries (see Details).}

\item{theta}{variable to map angle to (\code{x} or \code{y})}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{direction}{1, clockwise; -1, anticlockwise}

\item{clip}{Should drawing be clipped to the extent of the plot panel? A
setting of \code{"on"} (the default) means yes, and a setting of \code{"off"}
means no. For details, please see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}.}

\item{fill}{The fill color of the background. The default is to use the
\code{color} column included in \code{dat}. If a custom dataset is provided with
\code{dat} without a \code{color} column and without fill, a greyscale will be used.
Custom fill colors can be provided with this option (overriding the \code{color}
column) and will be recycled if/as necessary.}

\item{alpha}{The transparency of the fill colors.}

\item{lwd}{Line width for lines between intervals. Set to \code{NULL} to remove
lines.}

\item{color}{The color of the lines between intervals.}

\item{lty}{Line type for lines between intervals.}

\item{lab}{Whether to include labels. Requires the \code{geomtextpath} package.}

\item{abbrv}{If including labels, whether to use abbreviations instead of
full interval names.}

\item{skip}{A vector of interval names indicating which intervals should not
be labeled. If \code{abbrv} is \code{TRUE}, this can also include interval
abbreviations.}

\item{neg}{Set this to true if your theta-axis is using negative values. This
is usually true if you are using \code{ggtree}.}

\item{prop}{This is the rotational proportion of the background that the
scale takes up.}

\item{textpath_args}{A list of named arguments to provide to
\code{\link[geomtextpath:geom_textpath]{geomtextpath::geom_textpath()}}. Only used if \code{lab} is set to \code{TRUE}.
Useful arguments include \code{color} (font color), \code{family} (font family),
\code{fontface}, \code{hjust} (radial adjustment), and \code{size} (font size).}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{coord_geo_polar} behaves similarly to \code{\link[ggplot2:coord_polar]{ggplot2::coord_polar()}} in that it
occurs after statistical transformation and will affect the visual appearance
of geoms. The main difference is that it also adds a geological timescale to
the background of the plot.
}
\details{
If a custom data.frame is provided (with \code{dat}), it should consist of at
least 2 columns of data. See \code{data(periods)} for an example.
\itemize{
\item The \code{max_age} column lists the oldest boundary of each time interval.
\item The \code{min_age} column lists the youngest boundary of each time
interval.
\item The \code{abbr} column is optional and lists abbreviations that may be
used as labels.
\item The \code{color} column is optional and lists a \link[ggplot2:aes_colour_fill_alpha]{color}
for the background for each time interval.
}

\code{dat} may also be a list of values and/or dataframes if multiple time scales
should be added to the background. Scales will be added sequentially starting
at \code{start} and going in the specified \code{direction}. By default the scales will
all be equal in circular/rotational proportion, but this can be overridden
with \code{prop}. If \code{dat} is a list, \code{fill}, \code{alpha}, \code{lwd}, \code{color}, \code{lty},
\code{lab}, \code{abbrv}, \code{skip}, \code{neg}, \code{prop}, and \code{textpath_args} can also be lists
(N.B. \code{textpath_args} would be a list of lists). If these lists are not as
long as \code{dat}, the elements will be recycled. If individual values (or
vectors) are used for these parameters, they will be applied to all time
scales (and recycled as necessary).

If the sum of the \code{prop} values is greater than 1, the proportions will be
scaled such that they sum to 1. However, the \code{prop} values may sum to less
than 1 if the user would like blank space in the background.

\code{coord_geo_polar} manually generates the \code{r} axis, meaning it does not
support changing the guide features of ggplot v. 2.5.0 or later. However, the
\code{deeptime.axis.line.r}, \code{deeptime.axis.text.r}, \code{deeptime.axis.ticks.r}, and
\code{deeptime.axis.ticks.length.r} ggplot2 \link[ggplot2:theme]{theme elements} can
be modified just like their x and y counterparts to change the appearance of
the radius axis. The default settings work well for a horizontal axis
pointing towards the right, but these theme settings will need to be modified
for other orientations. The default value for \code{deeptime.axis.line.r} is
\code{element_line()}. The default value for \code{deeptime.axis.text.r} is
\code{element_text(size = 3.5, vjust = -2, hjust = NA)}. The default value for
\code{deeptime.axis.ticks.r} is \code{element_line()}. The default value for
\code{deeptime.axis.ticks.length.r} is \code{unit(1.5, "points")}. However, note that
the units for this element are meaningless and only the numeric value will be
used (but a \code{unit} must still be used).

Care must be taken when adding labels to plots, as they are very likely to
overlap with the plot under the default settings. The \code{textpath_args}
argument can be used to adjust the settings for the plotting of the labels.
See \code{\link[geomtextpath:geom_textpath]{geomtextpath::geom_textpath()}} for details about the available
arguments. Also note that the curvature of the labels may vary based on the
distance from the origin. This is why \code{abbrv} is set to \code{TRUE} by default.
}
\section{Life cycle}{
 This function is soft-deprecated in favor of
\code{\link[=coord_geo_radial]{coord_geo_radial()}} as of \strong{deeptime} version 1.1.0. There is currently
no plan to remove this function, but users are strongly encouraged to
migrate to the new function for enhanced polar functionality.
}

\examples{
library(ggplot2)
\dontshow{if (require(ggtree)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggtree)
set.seed(1)
tree <- rtree(100)
# single scale
revts(ggtree(tree)) +
  coord_geo_polar(dat = "stages")

# multiple scales
revts(ggtree(tree)) +
  coord_geo_polar(
    dat = list("stages", "periods"), alpha = .5,
    prop = list(0.75, .25), start = pi / 4, lty = "dashed"
  ) +
  scale_y_continuous(expand = expansion(mult = c(0.02, 0.02))) +
  theme(deeptime.axis.text.r = element_text(size = 3.5, hjust = .75,
                                            vjust = .75))
\dontshow{\}) # examplesIf}
\dontshow{if (require(ggtree) && require(paleotree)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(ggplot2)
library(paleotree)
data(RaiaCopesRule)
ggtree(ceratopsianTreeRaia,
       position = position_nudge(x = -ceratopsianTreeRaia$root.time)) +
  coord_geo_polar(dat = "stages")
\dontshow{\}) # examplesIf}
}
\keyword{datasets}
