% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eras}
\alias{eras}
\title{Era data from the International Commission on Stratigraphy (v2022/10)}
\format{
A data frame with 10 rows and 5 variables:
\describe{
\item{name}{era name}
\item{max_age}{maximum age, in millions of years}
\item{min_age}{minimum age, in millions of years}
\item{abbr}{era name abbreviations}
\item{color}{the colors for each era, according to the Commission for the
Geological Map of the World}
}
}
\source{
\url{https://stratigraphy.org} via \url{https://macrostrat.org/api/v2/defs/intervals?timescale=international\%20eras}
}
\usage{
eras
}
\description{
A dataset containing the boundary ages, abbreviations, and colors for the
eras of the Geologic Time Scale. Based on The ICS International
Chronostratigraphic Chart (v2022/10), by Cohen, Finney, Gibbard, and Fan.
}
\seealso{
Other timescales: 
\code{\link{eons}},
\code{\link{epochs}},
\code{\link{periods}},
\code{\link{stages}}
}
\concept{timescales}
\keyword{datasets}
