% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepboost.R
\name{deepboost.default}
\alias{deepboost.default}
\title{Main function for deepboost model creation}
\usage{
deepboost.default(x, y, instance_weights = NULL, tree_depth = 5,
  num_iter = 1, beta = 0, lambda = 0.05, loss_type = "l",
  verbose = TRUE)
}
\arguments{
\item{x}{A data.frame of samples' values}

\item{y}{A data.frame of samples's labels}

\item{instance_weights}{The weight of each example}

\item{tree_depth}{maximum depth for a single decision tree in the model}

\item{num_iter}{number of iterations = number of trees in ensemble}

\item{beta}{regularisation for scores (L1)}

\item{lambda}{regularisation for tree depth}

\item{loss_type}{- "l" logistic, "e" exponential}

\item{verbose}{- print extra data while training TRUE / FALSE}
}
\value{
A trained Deepbost model
}
\description{
Main function for deepboost model creation
}
\examples{
deepboost.default(data.frame(x1=rep(c(0,0,1,1),2),x2=rep(c(0,1,0,1),2)),
 factor(rep(c(0,0,0,1),2)),num_iter=1)
deepboost.default(data.frame(x1=rep(c(0,0,1,1),2),x2=rep(c(0,1,0,1),2)),
 factor(rep(c(0,0,0,1),2)),
 num_iter=2, beta=0.1, lambda=0.00125)
}

