% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers_path-layer.R
\name{add_path_layer}
\alias{add_path_layer}
\title{Add a path layer to the deckgl widget}
\usage{
add_path_layer(deckgl, id = "path-layer", data = NULL,
  properties = list(), ...)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the layer.}

\item{data}{The url to fetch data from or a data object.}

\item{properties}{A named list of properties with names corresponding to the properties defined
in the \href{https://deck.gl/#/documentation/deckgl-api-reference}{deckgl-api-reference}
for the given layer class.}

\item{...}{More properties that will be added to the \code{properties} object. This can be useful
if you want to use a properties object for more than one layer.}
}
\description{
The \code{PathLayer} takes in lists of coordinate points and renders them as extruded lines with mitering.
}
\examples{
## @knitr path-layer
sample_data <- paste0(
  "https://raw.githubusercontent.com/",
  "uber-common/deck.gl-data/",
  "master/website/bart-lines.json"
)

properties <- list(
  pickable = TRUE,
  widthScale = 20,
  widthMinPixels = 2,
  getPath = ~path,
  getColor = ~color,
  getWidth = 5,
  getTooltip = ~name
)

deck <- deckgl(pitch = 25, zoom = 10.5) \%>\%
  add_path_layer(data = sample_data, properties = properties) \%>\%
  add_basemap() \%>\%
  add_control("Path Layer")

if (interactive()) deck
}
\seealso{
\url{https://deck.gl/#/documentation/deckgl-api-reference/layers/path-layer}
}
