% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mddsPLS.R
\name{mddsPLS}
\alias{mddsPLS}
\title{Multi-Data-Driven sparse PLS function}
\usage{
mddsPLS(Xs, Y, lambda = 0, R = 1, mode = "reg",
  errMin_imput = 1e-09, maxIter_imput = 50, verbose = FALSE)
}
\arguments{
\item{Xs}{A data-frame of a matrix or a list of data-frames or matrices of \emph{n} rows each, the number of individuals. Some rows must be missing. The different matrices can have different numbers of columns. The length of Xs is denoted by \emph{K}.}

\item{Y}{A matrix of \emph{n} rows of a vector of length \emph{n} detailing the response matrix. No missing values are allowed in that matrix.}

\item{lambda}{A real \eqn{[0,1]} where 1 means just perfect correlations will be used and 0 no regularization is used.}

\item{R}{A strictly positive integer detailing the number of components to build in the model.}

\item{mode}{A character chain. Possibilities are "\emph{reg}", which implies  regression problem or anything else which means clustering is considered.  Default is "\emph{reg}".}

\item{errMin_imput}{Positive real. Minimal error in the Tribe Stage of the Koh-Lanta algorithm. Default is \eqn{1e-9}.}

\item{maxIter_imput}{Positive integer. Maximal number of iterations in the Tribe Stage of the Koh-Lanta algorithm. If equals to \eqn{0}, mean imputation is  considered. Default is \eqn{5}.}

\item{verbose}{Logical. If TRUE, the function cats specificities about the model. Default is FALSE.}
}
\value{
A list containing a mddsPLS object, see \code{\link{MddsPLS_core}}.
}
\description{
This function takes a set \eqn{X} of \eqn{K} matrices defining the same \eqn{n} individuals and a matrix \eqn{Y} defining also those individuals. According to the num-
ber of components \eqn{R}, the user fixes the number of components the model
must be built on. The coefficient lambda regularizes the quality of proximity to the data choosing to forget the least correlated bounds between
\eqn{X} and \eqn{Y} datasets.
}
\examples{
# Single-block example :
## Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,stats::sd)>0)])
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),function(tt){rep(tt,12)})))
mddsPLS_model_class <- mddsPLS(Xs = X,Y = Y,lambda = 0.958,R = 2,mode = "clas",verbose = TRUE)

## Regression example :
data("liver.toxicity")
X <- scale(liver.toxicity$gene)
Y <- scale(liver.toxicity$clinic)
mddsPLS_model_reg <- mddsPLS(Xs = X,Y = Y,lambda=0.9,R = 1, mode = "reg",verbose = TRUE)

# Multi-block example :
## Classification example :
data("penicilliumYES")
X <- penicilliumYES$X
X <- scale(X[,which(apply(X,2,stats::sd)>0)])
Xs <- list(X[,1:1000],X[,-(1:1000)])
Xs[[1]][1:5,]=Xs[[2]][6:10,] <- NA
Y <- as.factor(unlist(lapply(c("Melanoconidiu","Polonicum","Venetum"),function(tt){rep(tt,12)})))
mddsPLS_model_class <- mddsPLS(Xs = Xs,Y = Y,lambda = 0.95,R = 2,mode = "clas",verbose = TRUE)

## Regression example :
data("liver.toxicity")
X <- scale(liver.toxicity$gene)
Xs <- list(X[,1:1910],X[,-(1:1910)])
Xs[[1]][1:5,]=Xs[[2]][6:10,] <- NA
Y <- scale(liver.toxicity$clinic)
mddsPLS_model_reg <- mddsPLS(Xs = Xs,Y = Y,lambda=0.9,R = 1, mode = "reg",verbose = TRUE)
}
\seealso{
\code{\link{predict.mddsPLS}}, \code{\link{perf_mddsPLS}}
}
