% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_natpsoho.R
\name{natVelocity}
\alias{natVelocity}
\title{R6 class that defines velocities in the PSO}
\arguments{
\item{ordering}{a vector with the names of the nodes in t_0}

\item{ordering_raw}{a vector with the names of the nodes without the appended "_t_0"}

\item{max_size}{maximum number of timeslices of the DBN}

\item{n}{the new number of operations that the velocity performs}

\item{probs}{the weight of each value {-1,0,1}. They define the probability that each of them will be picked}

\item{p}{the parameter of the geometric distribution}

\item{ps1}{the origin natPosition object}

\item{ps2}{the objective natPosition object}

\item{vl}{a Velocity object}

\item{k}{a real number}
}
\value{
A new 'natVelocity' object

the natVelocity that gets the ps1 to ps2
}
\description{
Constructor of the 'natVelocity' class. Only difference with the
natCauslist one is that it has a negative cl attribute.

Getter of the abs_op attribute.

return the number of operations that the velocity performs

Setter of the abs_op attribute. Intended for inside use only. 
This should be a 'protected' function in Java-like OOP, but there's no 
such thing in R6. This function should not be used from outside the
package.

Randomizes the Velocity's directions.

Given two positions, returns the velocity that gets the first position to the
other one.

Add both velocities directions

Multiply the Velocity by a constant real number

This function multiplies the Velocity by a constant real number. 
It is non deterministic by definition. When calculating k*|V|, the 
result will be floored and bounded to the set [-max_op, max_op], where max_op
is the maximum number of arcs that can be present in the network.
}
\details{
The velocities will be defined as two natural vectors where each element in
them represents the arcs from a temporal family of nodes to a receiving
node. 1-bits in the binary representation of this number represent arc 
additions/deletions
}
\section{Fields}{

\describe{
\item{\code{abs_op}}{Total number of operations 1 or -1 in the velocity}

\item{\code{max_size}}{Maximum number of timeslices of the DBN}

\item{\code{cl_neg}}{Negative part of the velocity}
}}

\keyword{internal}
