% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_psoho.R
\name{psoho}
\alias{psoho}
\title{Learn a DBN structure with a PSO approach}
\usage{
psoho(
  dt,
  size,
  n_inds = 50,
  n_it = 50,
  in_cte = 1,
  gb_cte = 0.5,
  lb_cte = 0.5,
  v_probs = c(10, 65, 25),
  r_probs = c(-0.5, 1.5)
)
}
\arguments{
\item{dt}{a data.table with the data of the network to be trained. Previously folded with the 'dbnR' package or other means.}

\item{size}{Number of timeslices of the DBN. Markovian order 1 equals size 2, and so on.}

\item{n_inds}{Number of particles used in the algorithm.}

\item{n_it}{Maximum number of iterations that the algorithm can perform.}

\item{in_cte}{parameter that varies the effect of the inertia}

\item{gb_cte}{parameter that varies the effect of the global best}

\item{lb_cte}{parameter that varies the effect of the local best}

\item{v_probs}{vector that defines the random velocity initialization probabilities}

\item{r_probs}{vector that defines the range of random variation of gb_cte and lb_cte}
}
\value{
A 'bn' object with the structure of the best network found
}
\description{
Given a dataset and the desired Markovian order, this function returns a DBN
structure ready to be fitted. It requires a folded dataset.
Original algorithm at https://doi.org/10.1109/BRC.2014.6880957
}
