% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_chronograms.R
\name{update_datelife_cache}
\alias{update_datelife_cache}
\title{Create an updated OpenTree chronograms database object}
\usage{
update_datelife_cache(
  write = TRUE,
  updated_name = "opentree_chronograms_updated",
  file_path = file.path(tempdir()),
  ...
)
}
\arguments{
\item{write}{Defaults to \code{TRUE}, it saves an .Rdata file named indicated by argument \code{name},
containing available chronograms from Open Tree of Life. Saves to path indicated by argument \code{path}.}

\item{updated_name}{Used if \code{write = TRUE}. Defaults to \code{"opentree_chronograms_updated"}. A character
vector of length one indicating the name to assign to both the updated OpenTree chronogram
database object and the ".Rdata" file. For example, if \code{name = "my_database"}, the
function will assign the updated chronogram database to an object named \code{my_database}
and will write it to a file named "my_database.Rdata" in the path indicated
by argument \code{file_path}.}

\item{file_path}{Used if \code{write = TRUE}. A character vector of length 1 indicating
the path to write the updated database ".Rdata" file to, excluding file name.
Defaults to temporary directory obtained with \code{\link[base:tempfile]{base::tempdir()}} and formatted with
\code{\link[base:file.path]{base::file.path()}}.}

\item{...}{
  Arguments passed on to \code{\link[=get_otol_chronograms]{get_otol_chronograms}}
  \describe{
    \item{\code{max_tree_count}}{Default to "all", it gets all available chronograms. For testing purposes, a numeric value indicating the max number of trees to be cached.}
  }}
}
\value{
A list of 4 elements:
\describe{
\item{authors}{A list of lists of author names of the original studies that
published chronograms currently stored in the Open Tree of Life database.}
\item{curators}{A list of lists of curator names that uplodaded chronograms
to the Open Tree of Life database.}
\item{studies}{A list of study identifiers from original studies that
published chronograms currently stored in the Open Tree of Life database.}
\item{trees}{A \code{multiPhylo} object storing the chronograms from Open Tree of
Life database.}
}
}
\description{
The function calls \code{\link[=get_otol_chronograms]{get_otol_chronograms()}} to update the OpenTree
chronograms database cached in datelife. It has the option to write the updated
object as an .Rdata file, that will be independent of the \code{opentree_chronograms}
data object that you can load with \code{data("opentree_chronograms", package = "datelife")}.
}
