% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodes.R
\encoding{UTF-8}
\name{load_prodes}
\alias{load_prodes}
\title{PRODES - Deforestation Monitoring Project in the Legal Amazon by Satellite}
\usage{
load_prodes(dataset = "prodes", raw_data, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("prodes").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on clearcut deforestation in the Legal Amazon and annual deforestation rates in the region. Survey is done at state or municipality level and data is available from 2000 to 2020.
}
\examples{
\dontrun{
# download raw data from 2000 to 2020
raw_prodes_all <- load_prodes(
  dataset = "prodes",
  raw_data = TRUE,
  time_period = 2000:2020
)
}

}
