% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_handle.R, R/ds_heap.R
\docType{methods}
\name{handle}
\alias{handle}
\alias{handle,heap,vector,missing-method}
\alias{handle,heap,missing,list-method}
\alias{handle,heap,missing,vector-method}
\alias{handle,heap,missing,matrix-method}
\title{Get the handles and values for nodes of a specific key in a heap.}
\usage{
handle(obj, key, value)

\S4method{handle}{heap,vector,missing}(obj, key)

\S4method{handle}{heap,missing,list}(obj, value)

\S4method{handle}{heap,missing,vector}(obj, value)

\S4method{handle}{heap,missing,matrix}(obj, value)
}
\arguments{
\item{obj}{a heap object}

\item{key}{a key in the heap}

\item{value}{a value in the heap}
}
\value{
returns extracted handles and values from \code{obj}
}
\description{
Returns a list of handles and values for node elements that have
 a specific key. That means for a given key, the reference to the node
 (the handle) as well as the value of the node are returned. If one key fits
 fits multiple nodes, all of the values and handles are returned. This is
 needed in order to uniquely identify a node if, for example,
 \code{decrease_key} on a specific node is going to be called.
}
\examples{
 # returns the handle of a heap
 f_heap <- fibonacci_heap("integer")
 f_heap <- insert(f_heap, 1:5, letters[1:5])

 handle(f_heap, key=3L)

 handle(f_heap, value=letters[3])

}
