% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geolocation.R
\name{geolocation}
\alias{geolocation}
\alias{geolocation<-}
\title{Get or Set the Geolocation of a Dataset Object}
\usage{
geolocation(x)

geolocation(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created by \code{\link[=dataset_df]{dataset_df()}} or
\code{dataset::as_dataset_df()}.}

\item{overwrite}{Logical. If \code{TRUE} (default), the existing \code{geolocation}
attribute is replaced with \code{value}. If \code{FALSE}, the function returns a
message and does not overwrite the existing value.}

\item{value}{A character string specifying the \code{geolocation}.}
}
\value{
A character string of length 1, representing the \code{geolocation}
attribute attached to \code{x}.
}
\description{
Access or assign the optional \code{geolocation} attribute to a semantically rich
dataset object.
}
\details{
The \code{geolocation} field describes the spatial region or named place where
the data was collected or that the dataset is about. This field is
recommended for data discovery in DataCite Metadata Schema 4.4.

See: \href{https://support.datacite.org/docs/datacite-metadata-schema-v44-recommended-and-optional-properties#18-geolocation}{DataCite: Geolocation Guidance}
}
\examples{
orange_dataset <- orange_df
geolocation(orange_df) <- "US"
geolocation(orange_df)

geolocation(orange_df, overwrite = FALSE) <- "GB"

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
