% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_check_dataresource.R
\name{dp_check_dataresource}
\alias{dp_check_dataresource}
\title{Check if a data set is valid given a Data Resource}
\usage{
dp_check_dataresource(
  x,
  dataresource = attr(x, "resource"),
  constraints = TRUE,
  throw = FALSE,
  tolerance = sqrt(.Machine$double.eps)
)
}
\arguments{
\item{x}{\code{data.frame} to check}

\item{dataresource}{\code{dataresource} object to check \code{x} against.}

\item{constraints}{also check relevant constraints in the field descriptor.}

\item{throw}{generate an error if the data set is not valid according to the 
dataresource.}

\item{tolerance}{numerical tolerance used in some of the tests}
}
\value{
Returns \code{TRUE} when the field is valid. Returns a character vector with
length >= 1 if the field is not valid. The text in the character values 
indicates why the field is not valid.

When \code{throw = TRUE} the function will generate an error instead of
returning a character vector. When the dataset is valid the function returns
\code{TRUE} invisibly.
}
\description{
Check if a data set is valid given a Data Resource
}
\seealso{
Use \code{\link{isTRUE}} to check if the test was successful. 
See \code{\link{dp_check_field}} for a function that checks a column or vector.
}
