% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuthenticationManager.R
\name{evaluateAuth}
\alias{evaluateAuth}
\alias{evaluateAuth,AuthenticationManager-method}
\title{Evaluate DataONE authentication.}
\usage{
evaluateAuth(.Object, ...)

\S4method{evaluateAuth}{AuthenticationManager}(.Object, node)
}
\arguments{
\item{.Object}{an Authentication Object.}

\item{...}{additional parameters}

\item{node}{A D1Node object.}
}
\value{
A hash containing authentication information.
}
\description{
A valid DataONE authentication method is looked for and all
authentication information is retrieved from it.
}
\details{
If the node specified in the \code{'node'} parameter is a DataONE v2 node
or higher, then an authentication token is checked if one exists. If it is readable
and not expired, then information for the token is returned. If a valid token does
not exist, then the X.509 certificate is checked, if it exists. If it is valid
then information is returned for the certificate.
}
