% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_transforms.R
\name{drLM}
\alias{drLM}
\title{LM Transformation Method}
\usage{
drLM(...)
}
\arguments{
\item{\ldots}{arguments you would pass to the \code{\link{lm}} function}
}
\value{
An object of class \code{drCoef} that contains the lm coefficients and other data needed by \code{\link{combMeanCoef}}
}
\description{
LM transformation method -- -- Fit a linear model to each subset
}
\details{
This provides a transformation function to be called for each subset in a recombination MapReduce job that applies R's lm method and outputs the coefficients in a way that \code{\link{combMeanCoef}} knows how to deal with.  It can be applied to a ddf with \code{\link{addTransform}} prior to calling \code{\link{recombine}}.
}
\examples{
# Divide the data
bySpecies <- divide(iris, by = "Species")

# A function to fit a multiple linear regression model to each species
linearReg <- function(x)
  drLM(Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width,
       data = x)

# Apply the transform and combine using 'combMeanCoef'
bySpecies \%>\%
  addTransform(linearReg) \%>\%
  recombine(combMeanCoef)

}
\author{
Landon Sego
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{rrDiv}}
}

