% Generated by roxygen2 (4.0.2): do not edit by hand
\name{processQWData}
\alias{processQWData}
\title{Processing of USGS NWIS Water Quality Data}
\usage{
processQWData(data, pCode = TRUE)
}
\arguments{
\item{data}{dataframe from Water Quality Portal}

\item{pCode}{logical if TRUE, assume data came from a pCode search, if FALSE, characteristic name.}
}
\value{
data dataframe with first column dateTime, and at least one qualifier and value columns
(subsequent qualifier/value columns could follow depending on the number of parameter codes)
}
\description{
Processes water quality portal data. This function looks at detection limit and detection
conditions to determine if a value is left censored or not. Censored values are given the qualifier
"<".  The dataframe is also converted from a long to wide format.
}
\examples{
# These examples require an internet connection to run
\dontrun{
rawSample <- getWQPqwData('USGS-01594440','', '', '')
rawSampleSelect <- processQWData(rawSample)
}
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

