% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_from_date.R
\name{generate_date_diffs}
\alias{generate_date_diffs}
\title{Date difference}
\usage{
generate_date_diffs(
  data_set,
  cols = "auto",
  analysis_date = NULL,
  units = "years",
  drop = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of date column(s) name(s) of data_set to commute difference on. To transform all
dates, set it to "auto". (character, default to "auto")}

\item{analysis_date}{Static date (Date or POSIXct, optional)}

\item{units}{Unit of difference between too dates (string, default to 'years')}

\item{drop}{Should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{verbose}{should the function log (logical, default to TRUE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\value{
data_set (as a \code{\link{data.table}}) with more columns.
A numeric column has been added for every couple of Dates. The result is in years.
}
\description{
Perform the differences between all dates of the data_set set and optionally with a static date.
}
\details{
\code{units} is the same as \code{\link{difftime}} units, but with one more possibility: years.
}
\examples{
# First build a useful data_set set
require(data.table)
data_set <- data.table(ID = seq_len(100),
                  date1 = seq(from = as.Date("2010-01-01"),
                              to = as.Date("2015-01-01"),
                              length.out = 100),
                  date2 = seq(from = as.Date("1910-01-01"),
                              to = as.Date("2000-01-01"),
                              length.out = 100)
                  )

# Now let's compute
data_set <- generate_date_diffs(data_set, cols = "auto", analysis_date = as.Date("2016-11-14"))
}
