% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataMaid-package.R
\docType{data}
\name{artData}
\alias{artData}
\title{Semi-artificial data about masterpieces of art}
\format{
A data frame with 200 rows and 11 variables.
\describe{
   \item{ArtistID}{A unique ID used for cataloging the artists (fictional).}
   \item{ArtistName}{The name of the artist.}
   \item{NoOfMiddlenames}{The number of middlenames the artist has.}
   \item{Title}{The title of the painting.}
   \item{Year}{The approximate year in which the painting was made.}
   \item{Location}{The current location of the painting.}
   \item{Continent}{The continent of the current location of the painting.}
   \item{Width}{The width of the painting, in centimeters.}
   \item{Height}{The height of the painting, in centimers.}
   \item{Media}{The media/materials of the painting.}
   \item{Movement}{The artistic movement(s) the painting belongs to.}
}
}
\source{
Semi-artificial dataset constructed based on the Master Works of Art dataset available from 
\href{https://www.data-explorer.com/data/}{Data Explorer}.
}
\usage{
artData
}
\description{
A dataset with information about 200 painting and their painters.
Each observation in the dataset corresponds to a painting. A single artificial variable, 
namely an artist ID variable, has been included. Otherwise the information should 
be truthful.
}
\examples{
data(artData)

}
\keyword{datasets}
