% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isSupported.R
\name{isSupported}
\alias{isSupported}
\title{Check if a variable has a class supported by dataMaid}
\usage{
isSupported(v)
}
\arguments{
\item{v}{A variable (vector) to check. All variable types are allowed.}
}
\value{
A \code{\link{checkResult}} with three entires: 
\code{$problem} (a logical indicating whether \code{v} contains only one value), 
\code{$message} (if a problem was found, a message describing which single 
value the variable takes and how many missing observations it contains, otherwise 
""), and \code{$problemValues} (always \code{NULL}).
}
\description{
A \code{\link{checkFunction}} that checks if \code{v} has 
one of the classes supported by dataMaid, namely \code{character},
\code{factor}, \code{numeric}, \code{integer}, \code{labelled},
\code{haven_labelled},
\code{logical} and \code{Date} (inlcuding other classes that inherits
from any of these classes). A user supported list can be provided
in the \code{treatXasY} argument, which will let the user decide
how unsupported classes should be treated. This
function is intended for use as a precheck in \code{\link{makeDataReport}}.
}
\examples{
integerVar <- 1:10 #supported
rawVar <- as.raw(1:10) #not supported

isSupported(integerVar)
isSupported(rawVar)

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}}, 
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
