% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyNums.R
\name{identifyNums}
\alias{identifyNums}
\title{A checkFunction}
\usage{
identifyNums(v, nVals = 12, ...)
}
\arguments{
\item{v}{A character, factor, or labelled variable to check.}

\item{nVals}{An integer determining how many unique values a variable must have
before it can potentially be determined to be a misclassified numeric variable. 
The default is \code{12}.}

\item{...}{Not in use.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating the variable is suspected to be
a misclassified numeric variable), \code{$message} (if a problem was found,
the following message: "Note: The variable consists exclusively of numbers and takes
a lot of different values. Is it perhaps a misclassified numeric variable?",
otherwise "") and \code{$problemValues} (always \code{NULL}).
}
\description{
A \code{\link{checkFunction}} to be called from
\code{\link{check}} for identifying numeric variables that have
been misclassified as categorical.
}
\details{
A categorical variable is suspected to be a misclassified
numeric variable if it has the following two properties: First,
it should consist exclusively of numbers (possibly including signs
and decimals points). Secondly, it must have at least \code{nVals} unique values.
The default values of \code{nVals} is 12, which means that 
e.g. variables including answers on a scale from 0-10 will
not be recognized as misclassified numerics.
}
\examples{
 #Positive and negative numbers, saved as characters
 identifyNums(c(as.character(-9:9)))

 #An ordinary character variable
 identifyNums(c("a", "b", "c", "d", "e.f", "-a", 1:100))


}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
