% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyLoners.R
\name{identifyLoners}
\alias{identifyLoners}
\title{A checkFunction for identifying sparsely represented values (loners)}
\usage{
identifyLoners(v, nMax = 10)
}
\arguments{
\item{v}{A character, labelled, or factor variable to check.}

\item{nMax}{The maximum number of problematic values to report. 
Default is \code{10}. Set to \code{Inf} if all problematic values are to be included 
in the outputted message, or to \code{0} for no output.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether case issues where found),
\code{$message} (a message describing which values in \code{v} were loners) and
\code{$problemValues} (the problematic values in their original format).
Note that Only unique problematic values
are listed and they are presented in alphabetical order.
}
\description{
A \code{\link{checkFunction}} to be called from \code{\link{check}} that identifies values that
only occur less than 6 times in factor, labelled, or character variables (that is, loners).
}
\details{
For character, labelled, and factor variables, identify values that only have a
very low number of observations, as these categories might be
problematic when conducting an analysis. Unused factor levels are
not considered "loners". "Loners" are defined as values with 5 or less
observations, reflecting the commonly use rule of thumb for performing
chi squared tests.
}
\examples{
identifyLoners(c(rep(c("a", "b", "c"), 10), "d", "d"))

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
