% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{dcrowchart}
\alias{dcrowchart}
\title{dcrowchart adds a row chart to the dashboard}
\usage{
dcrowchart(x, title = paste(x, "row chart"), spansize = 4,
  width = dashboard.env$outerwidth * spansize/12, height = 250)
}
\arguments{
\item{x}{column name of data frame \code{data} for drawing a row chart}

\item{title}{character for the title of the generated row chart}

\item{spansize}{integer between 1 to 12 for the width of the element in the web page}

\item{width}{integer for the width (in pixels) of the chart in the web page}

\item{height}{integer for the height (in pixels) of the chart in the web page}
}
\description{
\code{dcrowchart} generates a horizontal bar chart
}
\examples{
dashboard_open(data=iris) # other options: pathoutput=getwd() ...
dcpiechart(x=names(iris)[5])
dcbarchart(x=names(iris)[1] , gap=75)
dcrowchart(x=names(iris)[5] )
dcpiechart(x=names(iris)[2])
dctable(index=names(iris)[5])
dashboard_launch(browse = FALSE) # Just generates files. Server is not launched
}

