% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.spautocor.R
\name{utils.spautocor}
\alias{utils.spautocor}
\title{Spatial autocorrelation coefficient calculations}
\usage{
utils.spautocor(
  GD,
  GGD,
  permutation = FALSE,
  bootstrap = FALSE,
  bins = 10,
  reps
)
}
\arguments{
\item{GD}{Genetic distance matrix.}

\item{GGD}{Geographic distance matrix.}

\item{permutation}{Whether permutation calculations for the null hypothesis 
of no spatial structure should be carried out [default TRUE].}

\item{bootstrap}{Whether bootstrap calculations to compute the 95\% confidence
intervals around r should be carried out [default TRUE].}

\item{bins}{The number of bins for the distance classes
(i.e. \code{length(bins) == 1)} or a vectors with the break points. See 
details [default 5].}

\item{reps}{The number to be used for permutation and bootstrap analyses
[default 100].}
}
\value{
Returns a data frame with the following columns:
\enumerate{
\item Bin  The distance classes
\item N The number of pairwise comparisons within each distance class
\item r.uc The uncorrected autocorrelation coefficient
}
if both \code{bootstap} and \code{permutation} are \code{FALSE} otherwise only
\code{r} estimates are returned
}
\description{
Carries out calculation for spatial autocorrelation coefficient
starting from a genetic and geogaphic distance matrix.
}
\details{
The code of this function is based one \code{spautocorr} from the package
\code{PopGenReport}, which has been modified to fix a few bugs (as of
\code{PopGenReport v 3.0.4} and allow calculations of bootstraps estimates.

See details from \code{gl.spatial.autoCorr} for a detailed explanation.
}
\examples{
# See gl.spatial.autoCorr
}
\references{
\itemize{
\item Smouse PE, Peakall R. 1999. Spatial autocorrelation analysis of
individual multiallele and multilocus genetic structure. Heredity 82:
561-573.

\item Double, MC, et al. 2005. Dispersal, philopatry and infidelity: dissecting
local genetic structure in superb fairy-wrens (Malurus cyaneus). Evolution
59, 625-635.

\item Peakall, R, et al. 2003. Spatial autocorrelation analysis offers new
insights into gene flow in the Australian bush rat, Rattus fuscipes.
Evolution 57, 1182-1195.

\item Smouse, PE, et al. 2008. A heterogeneity test for fine-scale genetic
structure. Molecular Ecology 17, 3389-3400.

\item Gonzales, E, et al. 2010. The impact of landscape disturbance on spatial
genetic structure in the Guanacaste tree, Enterolobium
cyclocarpum(Fabaceae). Journal of Heredity 101, 133-143.

\item Beck, N, et al. 2008. Social constraint and an absence of sex-biased
dispersal drive fine-scale genetic structure in white-winged choughs.
Molecular Ecology 17, 4346-4358.
}
}
\seealso{
\code{\link{gl.spatial.autoCorr}}
}
\author{
Carlo Pacioni & Bernd Gruber
}
