% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2eigenstrat.r
\name{gl2eigenstrat}
\alias{gl2eigenstrat}
\title{Converts a genlight object into eigenstrat format}
\usage{
gl2eigenstrat(
  x,
  outfile = "gl_eigenstrat",
  outpath = tempdir(),
  snp_pos = 1,
  snp_chr = 1,
  pos_cM = 0,
  sex_code = "unknown",
  phen_value = "Case",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file [default 'gl_eigenstrat'].}

\item{outpath}{Path where to save the output file
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.'
 when calling this function to direct output files to your working directory.}

\item{snp_pos}{Field name from the slot loc.metrics where the SNP position is
stored [default 1].}

\item{snp_chr}{Field name from the slot loc.metrics where the chromosome of
each is stored [default 1].}

\item{pos_cM}{A vector, with as many elements as there are loci, containing
the SNP position in morgans or centimorgans [default 1].}

\item{sex_code}{A vector, with as many elements as there are individuals,
containing the sex code ('male', 'female', 'unknown') [default 'unknown'].}

\item{phen_value}{A vector, with as many elements as there are individuals,
containing the phenotype value ('Case', 'Control') [default 'Case'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\description{
The output of this function are three files:
\itemize{
\item genotype file: contains genotype data for each individual at each SNP
with an extension 'eigenstratgeno.'
\item snp file: contains information about each SNP with an extension 'snp.'
\item indiv file: contains information about each individual with an
extension 'ind.'
}
}
\details{
Eigenstrat only accepts chromosomes coded as numeric values, as follows:
X chromosome is encoded as 23, Y is encoded as 24, mtDNA is encoded as
90, and XY is encoded as 91. SNPs with illegal chromosome values, such
as 0, will be removed.
}
\examples{
\donttest{
require("dartR.data")
gl2eigenstrat(platypus.gl,snp_pos='ChromPos_Platypus_Chrom_NCBIv1',
snp_chr = 'Chrom_Platypus_Chrom_NCBIv1')
}
}
\references{
\itemize{
\item Patterson, N., Price, A. L., & Reich, D. (2006). Population structure
and eigenanalysis. PLoS genetics, 2(12), e190.
\item Price, A. L., Patterson, N. J., Plenge, R. M., Weinblatt, M. E.,
Shadick, N. A., & Reich, D. (2006). Principal components analysis corrects
for stratification in genome-wide association studies. Nature genetics,
38(8), 904-909.
}
}
\author{
Custodian: Luis Mijangos (Post to \url{https://groups.google.com/d/forum/dartr})
}
