% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.allna.r
\name{gl.filter.allna}
\alias{gl.filter.allna}
\title{Filters loci that are all NA across individuals and/or populations 
with all NA across loci}
\usage{
gl.filter.allna(x, by.pop = FALSE, recalc = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the input genlight object [required].}

\item{by.pop}{If TRUE, loci that are all missing in any one population
are deleted [default FALSE]}

\item{recalc}{Recalculate the locus metadata statistics if any individuals
are deleted in the filtering [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
A genlight object having removed individuals that are scored NA
across all loci, or loci that are scored NA across all individuals.
}
\description{
This script deletes deletes loci or individuals with all calls missing (NA),
 from a genlight object

A DArT dataset will not have loci for which the calls are scored all as
missing (NA) for a particular individual, but such loci can arise rarely when
 populations or individuals are deleted. Similarly, a DArT dataset will not
 have individuals for which the calls are scored all as missing (NA) across
 all loci, but such individuals may sneak in to the dataset when loci are
 deleted. Retaining individual or loci with all NAs can cause issues for
 several functions.
 
 Also, on occasion an analysis will require that there are some loci scored
 in each population. Setting by.pop=TRUE will result in removal of loci when
 they are all missing in any one population.
 
Note that loci that are missing for all individuals in a population are
not imputed with method 'frequency' or 'HW'. Consider 
using the function \code{\link{gl.filter.allna}} with by.pop=TRUE.
}
\examples{
# SNP data
  result <- gl.filter.allna(testset.gl, verbose=3)
# Tag P/A data
  result <- gl.filter.allna(testset.gs, verbose=3)

}
\seealso{
Other filters and filter reports: 
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.reproducibility}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.taglength}()}
}
\author{
Author(s): Arthur Georges. Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filters and filter reports}
